% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_engines.R
\name{to_sentiment}
\alias{to_sentiment}
\title{Convert a sentiment table to a sentiment object}
\usage{
to_sentiment(s)
}
\arguments{
\item{s}{a \code{data.table} that can be converted into a \code{sentiment} object. It should have an \code{"id"},
a \code{"date"} and a \code{"word_count"} column. If other column names are provided with a separating \code{"--"},
the first part is considered the lexicon (or more generally, the sentiment computation method), and the second part
the feature. For sentiment column names without any \code{"--"}, a \code{"dummyFeature"} component is added.}
}
\value{
A \code{sentiment} object.
}
\description{
Converts a properly structured sentiment table into a \code{sentiment} object, that can be used
for further aggregation with the \code{\link{aggregate.sentiment}} function. This allows to start from document-level
sentiment scores not necessarily computed with \code{\link{compute_sentiment}}.
}
\examples{
set.seed(505)

ids <- paste0("id", 1:200)
date <- sample(seq(as.Date("2015-01-01"), as.Date("2018-01-01"), by = "day"), 200, TRUE)
word_count <- sample(150:850, 200, replace = TRUE)
sent <- matrix(rnorm(200 * 8), nrow =  200)
s1 <- s2 <- s3 <- data.table(id = ids, date = date, word_count = word_count, sent)
m <- "method"

colnames(s1)[-c(1:3)] <- paste0(m, 1:8)
sent1 <- to_sentiment(s1)

colnames(s2)[-c(1:3)] <- c(paste0(m, 1:4, "--", "feat1"), paste0(m, 1:4, "--", "feat2"))
sent2 <- to_sentiment(s2)

colnames(s3)[-c(1:3)] <- c(paste0(m, 1:3, "--", "feat1"), paste0(m, 1:3, "--", "feat2"),
                           paste0(m, 4:5))
sent3 <- to_sentiment(s3)

}
\author{
Samuel Borms
}
