% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-methods.R
\name{confint.semmccistd}
\alias{confint.semmccistd}
\title{Monte Carlo Confidence Intervals for the Standardized Parameter Estimates}
\usage{
\method{confint}{semmccistd}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{semmccistd}.}

\item{parm}{a specification of which parameters are to be given confidence intervals,
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Monte Carlo Confidence Intervals for the Standardized Parameter Estimates
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
x <- rnorm(n = n)
m <- 0.50 * x + rnorm(n = n)
y <- 0.25 * x + 0.50 * m + rnorm(n = n)
data <- data.frame(x, m, y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  y ~ cp * x + b * m
  m ~ a * x
  ab := a * b
"
fit <- sem(data = data, model = model, fixed.x = FALSE)

# Monte Carlo --------------------------------------------------------------
unstd <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)

# Standardized Monte Carlo -------------------------------------------------
std <- MCStd(unstd)
confint(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{method}
