% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by.R
\name{filter_by}
\alias{filter_by}
\title{Filter a Parameter Estimates
Table}
\usage{
filter_by(object, op = NULL, lhs = NULL, rhs = NULL, group = NULL, fit = NULL)
}
\arguments{
\item{object}{The output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}, or
a \code{lavaan.data.frame} object.
May also work on an \code{est_table}-class
object returned by functions
like \code{\link[=group_by_dvs]{group_by_dvs()}} but there
is no guarantee.}

\item{op}{A character vector of the
operators (\code{op}) for filtering.
Common operators are \code{"~"}, \code{"~~"},
\code{"=~"}, \code{":="}, and "\code{~1}".}

\item{lhs}{A character vector of
names in the \code{lhs} column.}

\item{rhs}{A character vector of
names in the \code{rhs} column.}

\item{group}{A vector of either the
group numbers in the \code{group} column
of the labels of the groups. If
labels are supplied, the original fit
object must be supplied for
extracting the group labels.}

\item{fit}{The original fit object.
Usd when \code{group} is a vector of the
group labels.}
}
\value{
The filtered version of the
input object.
}
\description{
Filter parameter
estimates table and similar tables
in\code{lavaan} by common fields such as
\code{op} (operator).
}
\details{
This functions accepts the
output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} and
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}} and
filter the rows by commonly used
field.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'
fit <- sem(model, data = dat, fixed.x = FALSE)

model_gp <-
'
m ~ c(a1, a2)*x
y ~ c(b1, b2)*m
a1b1 := a1*b1
a2b2 := a2*b2
'
dat$gp <- sample(c("gp1", "gp2"), n, replace = TRUE)
fit_gp <- sem(model_gp, dat, group = "gp", warn = FALSE)

est <- parameterEstimates(fit)
est_gp <- parameterEstimates(fit_gp)

filter_by(est, op = "~")

filter_by(est, op = "~", lhs = "y")

filter_by(est, rhs = c("m", "x"), op = "~")

filter_by(est_gp, group = 2)

# If the fit object is supplied, can filter
# by group label
filter_by(est_gp, group = "gp2", fit = fit_gp)
filter_by(est_gp, group = "gp2", fit = fit_gp, op = "~")

# Select user-defined parameters
filter_by(est_gp, op = ":=")

# Can be used with some other functions in semhelpinghands
# Piping can also be used
est_gp |> filter_by(op = "~", group = "gp2", fit = fit_gp) |>
          add_sig()


}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
