% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown_menu.R
\name{dropdown_menu}
\alias{dropdown_menu}
\alias{dropdownMenu}
\title{Create a dropdown menu.}
\usage{
dropdown_menu(..., type = "messages", icon = NULL, show_counter = TRUE)

dropdownMenu(..., type = "messages", icon = NULL, show_counter = TRUE)
}
\arguments{
\item{...}{UI elements to include within the dropdown menu.}

\item{type}{Type of the displayed items.}

\item{icon}{Icon of the dropdown menu. If not specyfied created based on \code{type} agrument.}

\item{show_counter}{If true circular label with counter is going to be shown for dropdown.}
}
\value{
A dropdown menu that can be passed to \code{\link[semantic.dashboard]{dashboardHeader}}
}
\description{
Create a dropdown menu with additional UI elements.
}
\section{Functions}{
\itemize{
\item \code{dropdownMenu}: Create a dropdown menu (alias for \code{dropdown_menu} for compatibility with \code{shinydashboard})
}}

\examples{
dropdownMenu(icon = icon("warning sign"), taskItem("Project progress...", 50.777, color = "red"))
dropdownMenu(type = "notifications", notificationItem("This is notification!", color = "red"))
}
