% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenienceFunctions.R
\name{semPower.powerCFA}
\alias{semPower.powerCFA}
\title{semPower.powerCFA}
\usage{
semPower.powerCFA(
  type,
  comparison = "restricted",
  phi,
  nullCor = NULL,
  lambda = NULL,
  nIndicator = NULL,
  loadM = NULL,
  loadSD = NULL,
  loadMinMax = NULL,
  ...
)
}
\arguments{
\item{type}{type of power analysis, one of 'a-priori', 'post-hoc', 'compromise'}

\item{comparison}{comparison model, one of 'saturated' or 'restricted'. This determines the df for power analyses. 'Saturated' provides power to reject the model when compared to the saturated model, so the df equal the one of the hypothesized model. 'Restricted' provides power to reject the model when compared to a model that just restricts the parameter defined by nullCor to zero, so the df are always 1.}

\item{phi}{factor correlation matrix or single number giving correlation between all factors}

\item{nullCor}{vector of size 2 indicating which factor correlation in phi is hypothesized to equal zero, e.g. c(1, 2) to refer to the correlation between first and second factor}

\item{lambda}{a list providing factor loadings by factor. Must not contain secondary loadings.}

\item{nIndicator}{vector indicating the number of indicators for each factor, e.g. c(4, 6) to define two factors with 4 and 6 indicators, respectively}

\item{loadM}{vector giving mean loadings for each factor or single number to use for every loading}

\item{loadSD}{vector giving the standard deviation of loadings for each factor for use in conjunction with loadM. When NULL, SDs are set to zero.}

\item{loadMinMax}{matrix giving the minimum and maximum loading for each factor or vector to apply to all factors}

\item{...}{other parameters related to the specific type of power analysis requested}
}
\value{
a list containing the results of the power analysis, Sigma and SigmaHat as well as several lavaan model strings (modelPop, modelTrue, and modelAna)
}
\description{
Convenience function for performing power analysis for simple CFA models involving one hypothesized zero correlation between factors.
This requires the lavaan package.
}
\examples{
\dontrun{
# a priori power analysis only providing the number of indicators to define 
# two factors with correlation of phi and same loading for all indicators
cfapower.ap <- semPower.powerCFA(type = 'a-priori', 
                                 phi = .2, nIndicator = c(5, 6), loadM = .5,
                                 alpha = .05, beta = .05)
                                 summary(cfapower.ap$power)

# sanity check: fit true model to population Sigma to evaluate everything was set up as intended
summary(lavaan::sem(cfapower.ap$modelTrue, sample.cov = cfapower.ap$Sigma,
                    sample.nobs = 1000, likelihood = 'wishart', sample.cov.rescale = FALSE),
        stand = TRUE)

# peek into lavaan model strings:
# population model
cfapower.ap$modelPop
# (incorrect) analysis model
cfapower.ap$modelAna

# or plug the population Sigma and model-implied SigmaHat 
# into a regular power analysis command 
ph <- semPower.aPriori(SigmaHat = cfapower.ap$SigmaHat, Sigma = cfapower.ap$Sigma, 
                       df = 1, alpha = .05, beta = .05)
                       summary(ph)

# same as above, but compare to the saturated model 
# (rather than to the less restricted model)
#' cfapower.ap <- semPower.powerCFA(type = 'a-priori', comparison = 'saturated', 
                                 phi = .2, nIndicator = c(5, 6), loadM = .5,
                                 alpha = .05, beta = .05)

# same as above, but request a compromise power analysis
cfapower.cp <- semPower.powerCFA(type = 'compromise',
                                 phi = .2, nIndicator = c(5, 6), loadM = .5,
                                 abratio = 1, N = 200)

# same as above, but request a post-hoc power analysis
cfapower.ph <- semPower.powerCFA(type = 'post-hoc', 
                                 phi = .2, nIndicator = c(5, 6), loadM = .5,
                                 alpha = .05, N = 200)

# post-hoc power analysis providing factor correlation matrix 
# and reduced loading matrix 
phi <- matrix(c(
                c(1.0, 0.1),
                c(0.1, 1.0)
              ), byrow = T, ncol = 2)

# lambda: only define primary loadings 
# must not contain secondary loadings
lambda <- list(
               c(0.4, 0.5, 0.8),
               c(0.7, 0.6, 0.5, 0.4)
               )

cfapower <- semPower.powerCFA(type = 'post-hoc',
                              phi = phi, nullCor = c(1, 2), lambda = lambda,
                              alpha = .05, N = 250)

# post-hoc power analysis providing factor correlation matrix, 
# number of indicators by factor, and min-max loading for all factors 
phi <- matrix(c(
                c(1.0, 0.2, 0.5),
                c(0.2, 1.0, 0.3),
                c(0.5, 0.3, 1.0)
               ), byrow = TRUE, ncol = 3)

cfapower <- semPower.powerCFA(type = 'post-hoc',
                              phi = phi, nullCor = c(1, 2), 
                              nIndicator = c(6, 5, 4), loadMinMax = c(.3, .8),
                              alpha = .05, N = 250)

# same as above, but providing mean and sd loading for all factors
cfapower <- semPower.powerCFA(type = 'post-hoc',
                              phi = phi, nullCor = c(1, 2), 
                              nIndicator = c(6, 5, 4), loadM = .5, loadSD = .1, 
                              alpha = .05, N = 250)

# same as above, but hypothesizing zero correlation between factors 2 and 3
cfapower <- semPower.powerCFA(type = 'post-hoc',
                              phi = phi, nullCor = c(2, 3), 
                              nIndicator = c(6, 5, 4), loadM = .5, loadSD = .1,
                              alpha = .05, N = 250)

# same as above, but providing mean and sd of loadings for each factor
cfapower <- semPower.powerCFA(type = 'post-hoc',
                              phi = phi, nullCor = c(1, 2), 
                              nIndicator = c(3, 6, 5), 
                              loadM = c(.5, .6, .7), loadSD = c(.1, .05, 0),
                              alpha = .05, N = 250)

# same as above, but using min-max loadings for each factor
loadMinMax <- matrix(c(
                       c(.4, .6),
                       c(.5, .8),
                       c(.3, .7)
                       ), byrow = TRUE, nrow = 3)

cfapower <- semPower.powerCFA(type = 'post-hoc',
                              phi = phi, nullCor = c(1, 2), nIndicator = c(3, 6, 5), 
                              loadMinMax = loadMinMax,
                              alpha = .05, N = 250)

}
}
