% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementState.R, R/elementStateDoc.R
\name{getElementAttribute}
\alias{getElementAttribute}
\title{Get the value of an element's attribute.}
\usage{
getElementAttribute(webElem, attribute, ...)
}
\arguments{
\item{webElem}{An object of class "wElement". A web Element object see \code{\link{wbElement}}.}

\item{attribute}{The attribute to query as a character string.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
The value of the attribute, or null if it is not set on the element.
}
\description{
\code{getElementAttribute} Get the value of an element's attribute.
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  # select the search box
  searchElem <- remDr \%>\% findElement("name", "q")

  # get the name of our element
  searchElem \%>\% getElementAttribute("name")

  # get the css background-color
  searchElem \%>\% getElementCssValue("background-color")
  blueScript <- "arguments[0].style.backgroundColor = 'blue';"
  remDr \%>\% executeScript(blueScript, list(searchElem))
  searchElem \%>\% getElementCssValue("background-color")

  # get the javascript property
  # searchElem \%>\% getElementProperty("backgroundColor")

  # get dimensions
  searchElem \%>\% getElementRect

  searchElem \%>\% getElementTagName

  # get some text and return it
  remDr \%>\% go("http://r-project.org")
  remDr \%>\% findElement("css", "h1") \%>\% getElementText

  # close browser
  remDr \%>\% deleteSession
}

}
\seealso{
Other elementState functions: \code{\link{getElementCssValue}},
  \code{\link{getElementProperty}},
  \code{\link{getElementRect}},
  \code{\link{getElementTagName}},
  \code{\link{getElementText}},
  \code{\link{isElementEnabled}},
  \code{\link{isElementSelected}}
}

