% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/js.R
\name{execute_js_fn}
\alias{execute_js_fn}
\alias{execute_js_expr}
\title{Execute a JavaScript function}
\usage{
execute_js_fn(fn, ..., .timeout = NULL, .session = NULL, .debug = FALSE)

execute_js_expr(expr, ..., .timeout = NULL, .session = NULL, .debug = FALSE)
}
\arguments{
\item{fn}{A string defining the function.}

\item{...}{Arguments to the function/expression. These must be unnamed, since
JavaScript does not support named arguments.}

\item{.timeout}{How long to wait for any elements to exist in the DOM.}

\item{.session}{The session to use, if \code{...} does not contain any
selenider elements.}

\item{.debug}{Whether to print the final expression that is executed. Mostly
used for debugging the functions themselves, but can also be used to
identify problems in your own JavaScript code.}

\item{expr}{An expression to execute.}
}
\value{
The return value of the JavaScript function, turned back into an R object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Execute a JavaScript function on zero or more arguments.

\code{execute_js_expr()} is a simpler version of \code{execute_js_fn()} that can
evaluate simple expressions (e.g. "alert()"). To return a value, you must
do so explicitly using "return".

These functions are experimental because their names and parameters are
liable to change. Additionally, their behaviour can be inconsistent between
different session types (chromote and selenium) and different browsers.
}
\details{
\code{...} can contain \code{selenider_element}/\code{selenider_elements} objects,
which will be collected and then passed into the function. However,
more complex objects (e.g. lists of selenider elements) will not be
moved into the JavaScript world correctly.

Similarly, nodes and lists of nodes returned from a JavaScript function will
be converted into their corresponding
\code{selenider_element}/\code{selenider_elements} objects, while more complex objects
will not. These elements are not lazy (see \code{\link[=elem_cache]{elem_cache()}}), so make sure you
only use them while you are sure they are still on the page.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<button class='mybutton'>Click me</button>
"
session <- minimal_selenider_session(html)

execute_js_fn("(x, y) => x + y", 1, 1)

execute_js_expr("arguments[0] + arguments[1]", 1, 1)

execute_js_fn("x => x.click()", s(".mybutton"))

execute_js_expr("arguments[0].click()", s(".mybutton"))
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{back}()},
\code{\link{current_url}()},
\code{\link{get_page_source}()},
\code{\link{open_url}()},
\code{\link{reload}()},
\code{\link{take_screenshot}()}
}
\concept{global actions}
