% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{has_attr}
\alias{has_attr}
\alias{attr_contains}
\alias{has_value}
\title{Does an element's attribute match a value?}
\usage{
has_attr(x, name, value)

attr_contains(x, name, value)

has_value(x, value)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{name}{The name of the attribute.}

\item{value}{The value of the attribute. For \code{has_attr()} and \code{has_value()},
this can be a string or a numeric value, while \code{attr_contains()} can only take
a string.}
}
\value{
A boolean value: TRUE or FALSE.
}
\description{
\code{has_attr()} checks that an element's attribute matches a value, while
\code{attr_contains()} checks that an element's attribute contains a value.

\code{has_value()} is a shortcut for \code{has_attr("value")}: it checks that an
element's value matches a string or number.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<input class='myclass' value='1.0' data-customattr='Custom attribute text'></p>
"

session <- minimal_selenider_session(html)

has_attr(s("input"), "class", "myclass")

has_attr(s("input"), "value", 1)
has_value(s("input"), 1)

attr_contains(s("input"), "data-customattr", "Custom attribute")

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_css_property}()},
\code{\link{has_length}()},
\code{\link{has_name}()},
\code{\link{has_text}()},
\code{\link{is_enabled}()},
\code{\link{is_present}()},
\code{\link{is_visible}()}
}
\concept{conditions}
