% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elem_flatten.R
\name{elem_flatten}
\alias{elem_flatten}
\alias{c.selenider_element}
\alias{c.selenider_elements}
\title{Combine multiple HTML elements}
\usage{
elem_flatten(...)

\method{c}{selenider_element}(...)

\method{c}{selenider_elements}(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> \code{selenider_element} or
\code{selenider_elements} objects to be combined, or lists of such objects.}
}
\value{
A \code{selenider_elements} object.
}
\description{
Combine a set of \code{selenider_element}/\code{selenider_elements} objects
into a single \code{selenider_elements} object, allowing you to
perform actions on them at once. \code{c()} and \code{elem_flatten()} do the same
thing, but \code{elem_flatten()} works when given a list of \code{selenider_element}/\code{selenider_elements}
objects.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div id='id1'></div>
<div class='.class2'></div>
<button id='button1'>Click me!</button>
<div class='button-container'>
  <button id='button2'>No, click me!</button>
</div>
"

session <- minimal_selenider_session(html)

button_1 <- s("#button1")
button_2 <- s("#button2")

buttons <- elem_flatten(button_1, button_2)

buttons |>
  elem_expect_all(is_enabled)

buttons |>
  as.list() |>
  lapply(elem_click)

# Doesn't just have to be single elements
first_2_divs <- ss("div")[1:2]

elem_flatten(first_2_divs, button_2) |>
  length()

# We would like to use multiple css selectors and combine the results
selectors <- c(
  "#id1", # Will select 1 element
  "button", # Will select 2 elements
  "p" # Will select 0 elements
)

lapply(selectors, ss) |>
  elem_flatten() |>
  length() # 3

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=as.list.selenider_elements]{as.list.selenider_elements()}} to iterate over element collections.
}
}
