% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.performance_simres.R
\name{plot.see_performance_simres}
\alias{plot.see_performance_simres}
\title{Plot method for check model for (non-)normality of residuals}
\usage{
\method{plot}{see_performance_simres}(
  x,
  size_line = 0.8,
  size_point = 2,
  alpha = 0.2,
  dot_alpha = 0.8,
  colors = c("#3aaf85", "#1b6ca8"),
  detrend = FALSE,
  transform = NULL,
  style = theme_lucid,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{size_line}{Numeric value specifying size of line geoms.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{alpha}{Numeric value specifying alpha level of the confidence bands.}

\item{dot_alpha}{Numeric value specifying alpha level of the point geoms.}

\item{colors}{Character vector of length two, indicating the colors (in
hex-format) for points and line.}

\item{detrend}{Logical that decides if Q-Q and P-P plots should be de-trended
(also known as \emph{worm plots}).}

\item{transform}{Function to transform the residuals. If \code{NULL} (default),
no transformation is applied and uniformly distributed residuals are expected.
See argument \code{quantileFuntion} in \code{?DHARMa:::residuals.DHARMa} for more details.}

\item{style}{A ggplot2-theme.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_residuals()} resp.
\code{performance::simulate_residuals()} function.
}
\examples{
\dontshow{if (insight::check_if_installed("performance", "0.10.9.7") && require("glmmTMB") && require("qqplotr") && require("DHARMa")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Salamanders, package = "glmmTMB")
model <- glmmTMB::glmmTMB(
  count ~ mined + spp + (1 | site),
  family = poisson(),
  data = Salamanders
)
simulated_residuals <- performance::simulate_residuals(model)
plot(simulated_residuals)

# or
simulated_residuals <- performance::simulate_residuals(model)
result <- performance::check_residuals(simulated_residuals)
plot(result)
\dontshow{\}) # examplesIf}
}
\seealso{
See also the vignette about \href{https://easystats.github.io/performance/articles/check_model.html}{\code{check_model()}}.
}
