% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_okabeito.R
\name{scale_color_okabeito}
\alias{scale_color_okabeito}
\alias{scale_fill_okabeito}
\alias{scale_colour_okabeito}
\alias{scale_fill_oi}
\title{Okabe-Ito color palette}
\usage{
scale_color_okabeito(
  palette = "full",
  reverse = FALSE,
  order = 1:9,
  aesthetics = "color",
  ...
)

scale_fill_okabeito(
  palette = "full",
  reverse = FALSE,
  order = 1:9,
  aesthetics = "fill",
  ...
)

scale_colour_okabeito(
  palette = "full",
  reverse = FALSE,
  order = 1:9,
  aesthetics = "color",
  ...
)

scale_fill_oi(
  palette = "full",
  reverse = FALSE,
  order = 1:9,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can
be \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"},
\code{"contrast"}, \code{"light"} (for dark themes), or \code{"black_first"}.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{order}{A vector of numbers from 1 to 9 indicating the order of colors to use
(default: \code{1:9})}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The Okabe-Ito color palette was proposed by Okabe and Ito (2008) as a
qualitative color palette that is accessible to people with a variety of
forms of color vision deficiency. In addition to being accessible, it
includes 9 vivid colors that are readily nameable and include colors that
correspond to major primary and secondary colors (e.g., red, yellow, blue).
}
\details{
The Okabe-Ito palette is included in the base R \code{\link[=palette.colors]{palette.colors()}}.
These functions make this palette easier to use with \emph{ggplot2}.

The Okabe-Ito palette is only available as a discrete palette.
For color-accessible continuous variables, consider
\link[ggplot2:scale_viridis]{the viridis palettes}.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_okabeito()

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_oi(palette = "black_first")

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_oi(order = c(1, 5, 6, 2, 4, 3, 7))
}
\references{
Okabe, M., & Ito, K. (2008). Color universal design (CUD):
How to make figures and presentations that are friendly to colorblind people.
https://jfly.uni-koeln.de/color/#pallet (Original work published 2002)
}
