% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_poolpoint.R
\name{geom_poolpoint}
\alias{geom_poolpoint}
\alias{geom_pooljitter}
\title{Pool ball points}
\usage{
geom_poolpoint(
  label,
  size_text = 3.88,
  size_background = size_text * 2,
  size_point = size_text * 3.5,
  ...
)

geom_pooljitter(
  label,
  size_text = 3.88,
  size_background = size_text * 2,
  size_point = size_text * 3.5,
  jitter = 0.1,
  ...
)
}
\arguments{
\item{label}{Label to add inside the points.}

\item{size_text}{Size of text.}

\item{size_background}{Size of the white background circle.}

\item{size_point}{Size of the ball.}

\item{...}{Other arguments to be passed to \code{geom_point}.}

\item{jitter}{Width and height of position jitter.}
}
\description{
Points labelled with the observation name.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Petal.Width, y = Sepal.Length, color = Species )) +
  geom_poolpoint(label = rownames(iris)) +
  scale_color_flat_d() +
  theme_modern()


ggplot(iris, aes(x = Petal.Width, y = Sepal.Length, color = Species )) +
  geom_pooljitter(label = rownames(iris)) +
  scale_color_flat_d() +
  theme_modern()

}
