% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_colorhex.R
\name{scale_color_colorhex}
\alias{scale_color_colorhex}
\alias{scale_color_colorhex_d}
\alias{scale_color_colorhex_c}
\alias{scale_colour_colorhex}
\alias{scale_colour_colorhex_c}
\alias{scale_colour_colorhex_d}
\alias{scale_fill_colorhex}
\alias{scale_fill_colorhex_d}
\alias{scale_fill_colorhex_c}
\title{Color palettes from color-hex}
\usage{
scale_color_colorhex(
  palette = 1014416,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_colorhex_d(
  palette = 1014416,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_colorhex_c(
  palette = 1014416,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_colorhex(
  palette = 1014416,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_colorhex_c(
  palette = 1014416,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_colorhex_d(
  palette = 1014416,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_fill_colorhex(
  palette = 1014416,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_colorhex_d(
  palette = 1014416,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_colorhex_c(
  palette = 1014416,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{The numeric code for a palette at \url{https://www.color-hex.com/}.
For example, \code{1014416} for the
\href{https://www.color-hex.com/color-palette/1014416}{Josiah color palette (number 1014416)}.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
This function creates color scales based on palettes from \url{https://www.color-hex.com/}.
This website provides a large number of user-submitted color palettes.
This function downloads a requested color palette from \url{https://www.color-hex.com/}.
and creates a \code{{ggplot2}} color scale from the provided hex codes.

Use \code{scale_color_colorhex_d} for \emph{discrete} categories and
\code{scale_color_colorhex_c} for a \emph{continuous} scale.
}
\note{
The default \href{https://www.color-hex.com/color-palette/1014416}{Josiah color palette (number 1014416)}
is available without an internet connection. All other color palettes require
an internet connection to download and access.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, color = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_color_colorhex_d(palette = 1014416)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_colorhex_d(palette = 1014416)

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_colorhex_c(palette = 1014416)
}
