\name{prepData}
\alias{prepData}
\title{Prepares concentration data and continuous ancillary data}
\usage{
  prepData(cdat, cavdat, yrstart, yrend, dcol, pnames,
    iwcav, qwcols)
}
\arguments{
  \item{cdat}{is the concentration data.}

  \item{cavdat}{is the continuous (daily) ancillary data.}

  \item{yrstart}{is the starting year of the analysis
  (treated as January 1 of that year).  Zero means the
  start date will be determined by the start date of
  cavdat, the continuous ancillary data.}

  \item{yrend}{is the ending year of the analysis (treated
  as December 31 of that year).  Zero means the end date
  will be determined by the end date of cavdat, the
  continuous ancillary data.}

  \item{dcol}{is the column name for the dates, should be
  the same for both cdat and cavdat.}

  \item{pnames}{are the parameters (water-quality
  constituents) to analyze (if using USGS parameters, omit
  the the starting 'P', such as "00945" for sulfate).}

  \item{iwcav}{is a character variable indicating which
  continuous ancillary variables to include, if none use
  iwcav=c("none").}

  \item{qwcols}{is a character vector with the beginning of
  the column headers for remarks code (default is R), and
  beginning of column headers for concentration data
  (default is P for parameter).}
}
\value{
  a list.  The first element is the concentration data with
  additional date information, missing values removed, and
  extra columns removed.  The second element is the
  continuous ancillary data with additional date
  information, missing values removed, and extra columns
  removed.
}
\description{
  prepData is usually called from within \link{fitswavecav}
  but can be invoked directly.  It performs some date
  calculations, removes rows with missing values for
  concentration or continous variables, and returns the the
  concentration and continuous ancillary data to be used by
  \link{fitswavecav} and its other internal functions.
}
\examples{
data(swData)
modMoRivOmaha<-combineData(qwdat=qwMoRivOmaha, cqwdat=cqwMoRivOmaha)
preppedDat <- prepData(modMoRivOmaha, cqwMoRivOmaha, yrstart=1995,
yrend=2003, dcol="dates", pnames=c("04035", "04037", "04041"),
iwcav=c("flowa30","flowa1"), qwcols=c("R","P"))
}
\author{
  Aldo V. Vecchia and Karen R. Ryberg
}
\keyword{manip}

