% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_example.R
\name{domain_example}
\alias{domain_example}
\title{Find the path to an example SDTM domain file}
\source{
See \url{https://cran.r-project.org/package=pharmaversesdtm}.
}
\usage{
domain_example(example)
}
\arguments{
\item{example}{A string with either the basename, file name, or relative path
to a SDTM domain example file bundled with \code{{stdm.oak}}, e.g. \code{"cm"}
(Concomitant Medication) or \code{"ae"} (Adverse Events).}
}
\value{
The local path to an example file if \code{example} is supplied, or a
character vector of example file names.
}
\description{
\code{\link[=domain_example]{domain_example()}} resolves the local path to a SDTM domain example file. The
domain examples files were imported from
\href{https://cran.r-project.org/package=pharmaversesdtm}{pharmaversesdtm}. See
Details section for available datasets.
}
\details{
Datasets were obtained from
\href{https://cran.r-project.org/package=pharmaversesdtm}{pharmaversesdtm} but are
originally sourced from the \href{https://github.com/cdisc-org/sdtm-adam-pilot-project}{CDISC pilot project} or have been
constructed ad-hoc by the
\href{https://cran.r-project.org/package=admiral}{admiral} team. These datasets
are bundled with \code{{sdtm.oak}}, thus obviating a dependence on
\code{{pharmaversesdtm}}.
\subsection{Example SDTM domains}{
\itemize{
\item \code{"ae"}: Adverse Events (AE) data set.
\item \code{"apsc"}: Associated Persons Subject Characteristics (APSC) data set.
\item \code{"cm"}: Concomitant Medications (CM) data set.
\item \code{"vs"}: Vital Signs (VS) data set.
}
}
}
\examples{
# If no example is provided it returns a vector of possible choices.
domain_example()

# Get the local path to the Concomitant Medication dataset file.
domain_example("cm")

# Local path to the Adverse Events dataset file.
domain_example("ae")

}
\seealso{
\code{\link[=read_domain_example]{read_domain_example()}}
}
