% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_helpers.R
\name{sf_voronoi_diagram}
\alias{sf_voronoi_diagram}
\title{generates voronoi diagram}
\usage{
sf_voronoi_diagram(sfj)
}
\arguments{
\item{sfj}{An \code{sf} object.}
}
\value{
An \code{sf} object of polygon geometry type or can be converted to this by \code{sf::st_as_sf()}.
}
\description{
Generates Voronoi diagram (Thiessen polygons) for sf object
}
\note{
Only sf objects of (multi-)point type are supported to generate voronoi diagram
and the returned result includes only the geometry column.
}
\examples{
library(sf)
pts = read_sf(system.file('extdata/pts.gpkg',package = 'sdsfun'))
pts_v = sf_voronoi_diagram(pts)

library(ggplot2)
ggplot() +
  geom_sf(data = pts_v, color = 'red',
          fill = 'transparent') +
  geom_sf(data = pts, color = 'blue', size = 1.25) +
  theme_void()

}
