/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.featureallocation;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.ddahl.commonsmath.package;
import org.ddahl.sdols.featureallocation.Feature;
import org.ddahl.sdols.featureallocation.Feature$;
import org.ddahl.sdols.featureallocation.FeatureAllocation;
import org.ddahl.sdols.featureallocation.FeatureAllocation$;
import org.ddahl.sdols.featureallocation.FeatureAllocationSummary$$anonfun$org$ddahl$sdols$featureallocation$FeatureAllocationSummary$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.immutable.ParSeq;
import scala.collection.parallel.immutable.ParSeq$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class FeatureAllocationSummary$ {
    public static final FeatureAllocationSummary$ MODULE$;

    static {
        new FeatureAllocationSummary$();
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<FeatureAllocation<A>> fas) {
        if (fas.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        int nItems = ((FeatureAllocation)fas.head()).nItems();
        Array2DRowRealMatrix zero = package.MatrixFactory$.MODULE$.apply(nItems, nItems);
        return org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix((Array2DRowRealMatrix)((ParIterableLike)fas.par()).aggregate((Function0)new Serializable(zero){
            public static final long serialVersionUID = 0L;
            private final Array2DRowRealMatrix zero$1;

            public final Array2DRowRealMatrix apply() {
                return this.zero$1;
            }
            {
                this.zero$1 = zero$1;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Array2DRowRealMatrix apply(Array2DRowRealMatrix sum, FeatureAllocation<A> x) {
                return org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(sum).$plus(x.pairwiseAllocationMatrix());
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Array2DRowRealMatrix apply(Array2DRowRealMatrix x$1, Array2DRowRealMatrix x$2) {
                return org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(x$1).$plus(x$2);
            }
        })).$colon$div((double)fas.size()).getData();
    }

    public <A> double sumOfSquaresSlow(FeatureAllocation<A> fa, double[][] pam) {
        return org.ddahl.commonsmath.package$.MODULE$.RichRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(fa.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x * x;
            }
        })).sum();
    }

    public <A> double sumOfAbsolutesSlow(FeatureAllocation<A> fa, double[][] pam) {
        return org.ddahl.commonsmath.package$.MODULE$.RichRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(org.ddahl.commonsmath.package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(fa.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$3) {
                return this.apply$mcDD$sp(x$3);
            }

            public double apply$mcDD$sp(double x$3) {
                return RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x$3));
            }
        })).sum();
    }

    private <A> double engine(int[][] counts, double[][] pam, Function1<Object, Object> f) {
        int nItems = pam.length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int[] countsi = counts[i];
            double[] pami = pam[i];
            sum1 += f.apply$mcDD$sp((double)countsi[i] - pami[i]);
            for (int j = 0; j < i; ++j) {
                sum2 += f.apply$mcDD$sp((double)countsi[j] - pami[j]);
            }
        }
        return sum1 + (double)2 * sum2;
    }

    public <A> double sumOfSquares(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x * x;
            }
        });
    }

    public <A> double sumOfAbsolutes(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x));
            }
        });
    }

    public <A> FeatureAllocation<A> minAmongDraws(Seq<FeatureAllocation<A>> candidates, int maxSize, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0)new Serializable(candidates){
            public static final long serialVersionUID = 0L;
            private final Seq candidates$1;

            public final double[][] apply() {
                return FeatureAllocationSummary$.MODULE$.expectedPairwiseAllocationMatrix(this.candidates$1);
            }
            {
                this.candidates$1 = candidates$1;
            }
        });
        Function2<FeatureAllocation<A>, double[][], Object> lossEngine = this.getLoss(loss);
        return (FeatureAllocation)((ParIterableLike)candidates.par()).minBy((Function1)new Serializable(maxSize, pam, lossEngine){
            public static final long serialVersionUID = 0L;
            private final int maxSize$1;
            private final double[][] pam$1;
            private final Function2 lossEngine$1;

            public final double apply(FeatureAllocation<A> feature) {
                return this.maxSize$1 > 0 && feature.size() > this.maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)this.lossEngine$1.apply(feature, (Object)this.pam$1));
            }
            {
                this.maxSize$1 = maxSize$1;
                this.pam$1 = pam$1;
                this.lossEngine$1 = lossEngine$1;
            }
        }, (Ordering)Ordering.Double$.MODULE$);
    }

    public ListBuffer<FeatureAllocation<Null$>> org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand(FeatureAllocation<Null$> fa, List<Feature<Null$>> availableFeatures, int i) {
        ListBuffer listBuffer;
        if (availableFeatures.isEmpty()) {
            listBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            FeatureAllocation<Null$> faPlus = fa.add(i, (Feature)availableFeatures.head());
            List tail = (List)availableFeatures.tail();
            listBuffer = tail.isEmpty() ? (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FeatureAllocation[]{fa, faPlus})) : (ListBuffer)this.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand(fa, (List<Feature<Null$>>)tail, i).$plus$plus(this.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand(faPlus, (List<Feature<Null$>>)tail, i));
        }
        return listBuffer;
    }

    public FeatureAllocation<Null$> org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$padWithFeature(FeatureAllocation<Null$> fa, Feature<Null$> f, int nTimes) {
        FeatureAllocation<Null$> fa2 = fa;
        for (int j = 0; j < nTimes; ++j) {
            fa2 = fa2.add(f);
        }
        return fa2;
    }

    public FeatureAllocation<Null$> org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$sequentiallyAllocatedLatentStructureOptimization(FeatureAllocation<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<FeatureAllocation<Null$>, double[][], Object> lossEngine) {
        int max = maxSize <= 0 ? Integer.MAX_VALUE : maxSize;
        ObjectRef fa = ObjectRef.create(initial);
        permutation.foreach((Function1)new Serializable(maxSize, pamTransform, lossEngine, max, fa){
            public static final long serialVersionUID = 0L;
            private final int maxSize$2;
            public final double[][] pamTransform$1;
            public final Function2 lossEngine$2;
            private final int max$1;
            private final ObjectRef fa$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                FeatureAllocation featureAllocation;
                Feature<Object> singleton = Feature$.MODULE$.apply(null, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{i}));
                int expectedNumberOfFeatures = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.pamTransform$1[i][i]));
                if (((FeatureAllocation)this.fa$1.elem).isEmpty()) {
                    featureAllocation = FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$padWithFeature((FeatureAllocation)this.fa$1.elem, singleton, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(expectedNumberOfFeatures), this.max$1));
                } else {
                    ListBuffer candidates = FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand((FeatureAllocation)this.fa$1.elem, ((FeatureAllocation)this.fa$1.elem).toList(), i);
                    int residualCapacity = this.maxSize$2 - ((FeatureAllocation)this.fa$1.elem).nFeatures();
                    ListBuffer candidates2 = residualCapacity > 0 ? (ListBuffer)candidates.map((Function1)new Serializable(this, singleton, expectedNumberOfFeatures, residualCapacity, i){
                        public static final long serialVersionUID = 0L;
                        private final Feature singleton$1;
                        private final int expectedNumberOfFeatures$1;
                        private final int residualCapacity$1;
                        private final int i$1;

                        public final FeatureAllocation<Null$> apply(FeatureAllocation<Null$> fa2) {
                            return FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$padWithFeature(fa2, this.singleton$1, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.expectedNumberOfFeatures$1 - fa2.nFeatures(this.i$1)), this.residualCapacity$1));
                        }
                        {
                            this.singleton$1 = singleton$1;
                            this.expectedNumberOfFeatures$1 = expectedNumberOfFeatures$1;
                            this.residualCapacity$1 = residualCapacity$1;
                            this.i$1 = i$1;
                        }
                    }, ListBuffer$.MODULE$.canBuildFrom()) : candidates;
                    featureAllocation = (FeatureAllocation)candidates2.minBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$sequentiallyAllocatedLatentStructureOptimization$1 $outer;

                        public final double apply(FeatureAllocation<Null$> x$4) {
                            return BoxesRunTime.unboxToDouble((Object)this.$outer.lossEngine$2.apply(x$4, (Object)this.$outer.pamTransform$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (Ordering)Ordering.Double$.MODULE$);
                }
                this.fa$1.elem = featureAllocation;
            }
            {
                this.maxSize$2 = maxSize$2;
                this.pamTransform$1 = pamTransform$1;
                this.lossEngine$2 = lossEngine$2;
                this.max$1 = max$1;
                this.fa$1 = fa$1;
            }
        });
        return (FeatureAllocation)fa.elem;
    }

    private <A> Function2<FeatureAllocation<A>, double[][], Object> getLoss(String loss) {
        String string;
        block4: {
            Object object;
            block3: {
                block2: {
                    string = loss;
                    if (!"squaredError".equals(string)) break block2;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(FeatureAllocation<A> fa, double[][] pam) {
                            return FeatureAllocationSummary$.MODULE$.sumOfSquares(fa, pam);
                        }
                    };
                    break block3;
                }
                if (!"absoluteError".equals(string)) break block4;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(FeatureAllocation<A> fa, double[][] pam) {
                        return FeatureAllocationSummary$.MODULE$.sumOfAbsolutes(fa, pam);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)string);
    }

    public Tuple2<FeatureAllocation<Null$>, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, int budgetInSeconds, double[][] pam, int maxSize, String loss) {
        Function2 lossEngine = this.getLoss(loss);
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x) {
                return this.apply$mcII$sp(x);
            }

            public int apply$mcII$sp(int x) {
                return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
            }
        });
        FeatureAllocation empty = FeatureAllocation$.MODULE$.empty(nItems);
        long budgetInMillis = budgetInSeconds <= 0 ? Long.MAX_VALUE : (long)budgetInSeconds * 1000L;
        long start = System.currentTimeMillis();
        ParSeq candidates = (ParSeq)((ParIterableLike)package$.MODULE$.Range().apply(0, nCandidates).par().map((Function1)new Serializable(pam, maxSize, lossEngine, rng, ints, empty, budgetInMillis, start){
            public static final long serialVersionUID = 0L;
            private final double[][] pam$2;
            private final int maxSize$3;
            private final Function2 lossEngine$3;
            private final Random rng$1;
            private final List ints$1;
            private final FeatureAllocation empty$1;
            private final long budgetInMillis$1;
            private final long start$1;

            public final FeatureAllocation<Null$> apply(int i) {
                List permutation = (List)this.rng$1.shuffle((TraversableOnce)this.ints$1, List$.MODULE$.canBuildFrom());
                return System.currentTimeMillis() - this.start$1 <= this.budgetInMillis$1 ? FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$sequentiallyAllocatedLatentStructureOptimization(this.empty$1, this.maxSize$3, (List<Object>)permutation, this.pam$2, (Function2<FeatureAllocation<Null$>, double[][], Object>)this.lossEngine$3) : null;
            }
            {
                this.pam$2 = pam$2;
                this.maxSize$3 = maxSize$3;
                this.lossEngine$3 = lossEngine$3;
                this.rng$1 = rng$1;
                this.ints$1 = ints$1;
                this.empty$1 = empty$1;
                this.budgetInMillis$1 = budgetInMillis$1;
                this.start$1 = start$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FeatureAllocation<Null$> x$5) {
                return x$5 != null;
            }
        });
        return new Tuple2(candidates.minBy((Function1)new Serializable(pam, lossEngine){
            public static final long serialVersionUID = 0L;
            private final double[][] pam$2;
            private final Function2 lossEngine$3;

            public final double apply(FeatureAllocation<Null$> x$6) {
                return BoxesRunTime.unboxToDouble((Object)this.lossEngine$3.apply(x$6, (Object)this.pam$2));
            }
            {
                this.pam$2 = pam$2;
                this.lossEngine$3 = lossEngine$3;
            }
        }, (Ordering)Ordering.Double$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)candidates.size()));
    }

    private FeatureAllocationSummary$() {
        MODULE$ = this;
    }
}

