% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{get_paleo_layers}
\alias{get_paleo_layers}
\title{Get the name of paleo climate layer(s) based on the current climate
layer(s)}
\usage{
get_paleo_layers(current_layer_codes, model_name = NA, epoch = NA,
  years_ago = NA)
}
\arguments{
\item{current_layer_codes}{character vector. Code(s) of the current climate
layers either as a character vector or as the dataframe provided by
\code{\link{list_layers}}.}

\item{model_name}{character vector. Paleo climate model name see the
\code{model_name} column in the result from
\code{\link{list_layers_paleo}}.}

\item{epoch}{character vector. Epoch for which you want the paleo layer, e.g.
\code{"mid-Holocene", "Last Glacial Maximum"}.}

\item{years_ago}{integer. Years for which you want the paleo layer, e.g.
\code{6000, 21000}.}
}
\value{
A dataframe with information on the paleo layer(s) matching the
  provided current layer(s).
}
\description{
\code{get_paleo_layers} returns information on the future climate layers for
the matching current climate layers.
}
\details{
Stops with an exception if no matching paleo layer was found for one
  or more of the provided current climate layer codes.
}
\examples{
paleo_layers <- get_paleo_layers("MS_biogeo08_sss_mean_5m", years_ago = 6000)
paleo_layers$layer_code
}
\seealso{
\code{\link{list_layers_paleo}}, \code{\link{list_layers}},
  \code{\link{load_layers}}
}
