% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{linesCirc}
\alias{linesCirc}
\title{Lines and arrows with vertical wrapping}
\usage{
linesCirc(x = seq_along(y), y, col = 1, lty = 1, ltyCross = lty,
  arrows = FALSE, ...)
}
\arguments{
\item{x}{vector with horizontal coordinates.}

\item{y}{vector with vertical coordinates, wrapped in \eqn{[-\pi,\pi)}.}

\item{col}{color vector of length \code{1} or the same length of \code{x} and \code{y}.}

\item{lty}{line type as in \code{\link[graphics]{par}}.}

\item{ltyCross}{specific line type for crossing segments.}

\item{arrows}{flag for drawing arrows instead of line segments.}

\item{...}{further graphical parameters passed to \code{\link[graphics]{segments}} or \code{\link[graphics]{arrows}}.}
}
\value{
Nothing. The functions are called for drawing wrapped lines.
}
\description{
Joins the corresponding points with line segments or arrows that exhibit wrapping in \eqn{[-\pi,\pi)} in the vertical axis.
}
\details{
\code{y} is wrapped to \eqn{[-\pi,\pi)} before plotting.
}
\examples{
x <- 1:100
y <- toPiInt(pi * cos(2 * pi * x / 100) + 0.5 * runif(50, -pi, pi))
plot(x, y, ylim = c(-pi, pi))
linesCirc(x = x, y = y, col = rainbow(length(x)), ltyCross = 2)
plot(x, y, ylim = c(-pi, pi))
linesCirc(x = x, y = y, col = rainbow(length(x)), arrows = TRUE)
}
