% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drifts.R
\name{driftMixVm}
\alias{driftMixVm}
\title{Drift for the mivM diffusion (circular case)}
\usage{
driftMixVm(x, alpha, mu, sigma, p, expTrc = 30)
}
\arguments{
\item{x}{vector with the evaluation points for the drift.}

\item{alpha}{vector of length \code{m} giving the strengths of the drifts.}

\item{mu}{vector of length \code{m} giving the means.}

\item{sigma}{diffusion coefficient.}

\item{p}{vector of length \code{m} giving the proportions. Must add to one.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A vector of the same length as \code{x} containing the drift.
}
\description{
Drift for the Langevin diffusion associated to a mixture of \code{m} independent von Mises (mivM) of dimension one.
}
\details{
\code{\link{driftMixIndVm}} is more general, but less efficient for the circular case. See Section 2.2.4 in García-Portugués et al. (2019) for details.
}
\examples{
x <- seq(-pi, pi, l = 200)
plot(x, x, type = "n", ylab = "drift")
for (i in 1:10) {
  lines(x, driftMixVm(x = x, alpha = c(2, 2), mu = c(0, -pi + 2 * pi * i / 10),
        sigma = 1, p = c(0.5, 0.5)), col = rainbow(10)[i])
}
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019) Langevin diffusions on the torus: estimation and applications. \emph{Statistics and Computing}, 29(2):1--22. \url{https://doi.org/10.1007/s11222-017-9790-2}
}
