% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_multiple.r,
%   R/methods_multiple_classes.r
\docType{methods}
\name{calc.multiple}
\alias{calc.multiple}
\alias{calc.multiple,character,list-method}
\title{perform calculations on multiple objects depending on argument \code{type}}
\usage{
calc.multiple(type, input)

\S4method{calc.multiple}{character,list}(type, input)
}
\arguments{
\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:
\itemize{
\item makePartitions: information on subtables required for HITAS and HYPECUBE algorithms
\item makeAttackerProblem: set up the attackers problem for a given (sub)table
\item calcFullProblem: calculate a complete problem object containing all information required to solve
the secondary cell suppression problem
}}

\item{input}{a list depending on argument \code{type} with two elements \code{"objectA"} and \code{"objectB"}
\itemize{
\item if type matches 'makePartitions':
\itemize{
\item \code{"object A"}: a \code{problemInstance} object
\item \code{"object B"}: a \code{dimInfo} object
}
\item if \code{type} matches 'makeAttackerProblem':
\itemize{
\item \code{"object A"}: a \code{sdcProblem} object
\item \code{"object B"}: ignored
}
\item \code{type} matches 'calcFullProblem'
\itemize{
\item \code{"object A"}: a \code{dataObj} object
\item \code{"object B"}: a \code{dimInfo} object
}
}}
}
\value{
manipulated data based on argument \code{type}
\itemize{
\item list with elements 'groups', 'indices', 'strIDs', 'nrGroups' and 'nrTables'
if argument \code{type} matches 'makePartitions'
\item object of class \code{linProb} if argument \code{type} matches 'makeAttackerProblem'
\item object of class \code{sdcProblem} if argument \code{type} matches 'calcFullProblem'
}
}
\description{
perform calculations on multiple objects depending on argument \code{type}
}
\note{
internal functions/methods
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
\keyword{internal}
