% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_functions.r
\name{attack}
\alias{attack}
\title{attacking primary suppressed cells and calculating current lower and upper bounds}
\usage{
attack(object, verbose = FALSE)
}
\arguments{
\item{object}{an object of class \code{\link{sdcProblem-class}}}

\item{verbose}{a logical vector specifying if output should be verbose (TRUE) or not (FALSE)}
}
\value{
a data.frame with column 'index' holding indices of primary suppressed cells and columns
'bounds_min' and 'bounds_max' featuring calculated lower and upper bounds for each cell.
Column 'protected' shows if a given cell is accordingly protected (TRUE) or not (FALSE).
}
\description{
Function \code{\link{attack}} is used to calculate lower and upper bounds for a given
sdcProblem (stored as object of class \code{\link{sdcProblem-class}}).
For all calculations the current suppression pattern is used when calculating solutions of the
attacker's problem.
}
\examples{
# load problem (as it was created after performing primary suppression
# in the example of \\code{\\link{primarySuppression}})
sp <- searchpaths()
fn <- paste(sp[grep("sdcTable", sp)], "/data/problemWithSupps.RData", sep="")
problem <- get(load(fn))

# calculate current lower|upper bounds given current suppression pattern
# (in this case consisting of primary suppressions only)
attack(problem, verbose=FALSE)
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
