% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-doc-audit.R
\name{write_doc_factory_map_conventions}
\alias{write_doc_factory_map_conventions}
\title{Documentation template for function factory conventions}
\usage{
write_doc_factory_map_conventions(
  ending,
  name_test1 = "GRIM",
  name_test2 = "GRIMMER"
)
}
\arguments{
\item{ending}{String (length 1). The part of your function factory's name
after \code{function_map_}. To}

\item{name_test1, name_test2}{Strings (length 1). Plain-text names of example
consistency tests. Defaults are \code{"GRIM"} and \code{"GRIMMER"}, respectively.}
}
\value{
A string vector formatted by \code{glue::glue()}.
}
\description{
\code{write_doc_factory_map_conventions()} creates a roxygen2 block
section to be inserted into the documentation of a function factory such as
\code{function_map_seq()} or \code{function_map_total_n()}. It lays out the naming
guidelines that users of your function factory should follow when creating
new manufactured functions.

Copy the output from your console and paste it into the roxygen2 block of
your function factory.
}
\examples{
# For `function_map_seq()`:
write_doc_factory_map_conventions(ending = "seq")

# For `function_map_total_n()`:
write_doc_factory_map_conventions(ending = "total_n")
}
\seealso{
For context, see
\href{https://lhdjung.github.io/scrutiny/articles/consistency-tests.html}{\emph{Implementing
consistency tests}}.
}
