% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-binary.R
\name{assert_input_binary}
\alias{assert_input_binary}
\title{Assert that inputs are correct for binary forecast}
\usage{
assert_input_binary(observed, predicted)
}
\arguments{
\item{observed}{Input to be checked. Should be a factor of length n with
exactly two levels, holding the observed values.
The highest factor level is assumed to be the reference level. This means
that \code{predicted} represents the probability that the observed value is
equal to the highest factor level.}

\item{predicted}{Input to be checked. \code{predicted} should be a vector of
length n, holding probabilities. Alternatively, \code{predicted} can be a matrix
of size n x 1. Values represent the probability that
the corresponding value in \code{observed} will be equal to the highest
available factor level.}
}
\value{
Returns NULL invisibly if the assertion was successful and throws an
error otherwise.
}
\description{
Function assesses whether the inputs correspond to the
requirements for scoring binary forecasts.
}
\keyword{internal_input_check}
