% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{select_metrics}
\alias{select_metrics}
\title{Select metrics from a list of functions}
\usage{
select_metrics(metrics, select = NULL, exclude = NULL)
}
\arguments{
\item{metrics}{A list of scoring functions.}

\item{select}{A character vector of scoring rules to select from the list. If
\code{select} is \code{NULL} (the default), all possible scoring rules are returned.}

\item{exclude}{A character vector of scoring rules to exclude from the list.
If \code{select} is not \code{NULL}, this argument is ignored.}
}
\value{
A list of scoring functions.
}
\description{
Helper function to return only the scoring rules selected by
the user from a list of possible functions.
}
\examples{
select_metrics(
  metrics = get_metrics(example_binary),
  select = "brier_score"
)
select_metrics(
  metrics = get_metrics(example_binary),
  exclude = "log_score"
)
}
\keyword{handle-metrics}
