% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_point_forecasts.R
\name{se_mean_sample}
\alias{se_mean_sample}
\title{Squared Error of the Mean (Sample-based Version)}
\usage{
se_mean_sample(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the number of Monte
Carlo samples. Alternatively, predictions can just be a vector of size n.}
}
\value{
vector with the scoring values
}
\description{
Squared error of the mean calculated as

\deqn{
  \textrm{mean}(\textrm{true\_value} - \textrm{prediction})^2
}{
  mean(true_value - mean_prediction)^2
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
se_mean_sample(true_values, predicted_values)
}
\seealso{
\code{\link[=squared_error]{squared_error()}}
}
\keyword{metric}
