% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard2}
\alias{scorecard2}
\title{Creating a Scorecard}
\usage{
scorecard2(bins, dt, y, x = NULL, posprob_pop = NULL, points0 = 600,
  odds0 = 1/19, pdo = 50, basepoints_eq0 = FALSE, digits = 0,
  return_prob = FALSE, positive = "bad|1", ...)
}
\arguments{
\item{bins}{Binning information generated from \code{woebin} function.}

\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. If it is NULL, then all variables in bins are used. Defaults to NULL.}

\item{posprob_pop}{Positive probability of population. Accepted range: 0-1,  default to NULL. If it is not NULL, the model will adjust for oversampling.}

\item{points0}{Target points, default 600.}

\item{odds0}{Target odds, default 1/19. Odds = p/(1-p).}

\item{pdo}{Points to Double the Odds, default 50.}

\item{basepoints_eq0}{Logical, defaults to FALSE. If it is TRUE, the basepoints will equally distribute to each variable.}

\item{digits}{The number of digits after the decimal point for points calculation. Default 0.}

\item{return_prob}{Logical, defaults to FALSE. If it is TRUE, the predict probability will also return.}

\item{positive}{Value of positive class, default "bad|1".}

\item{...}{Additional parameters.}
}
\value{
A list of scorecard data frames
}
\description{
\code{scorecard2} creates a scorecard based on the results from \code{woebin}. It has the same function of \code{scorecard}, but without model object input and provided adjustment for oversampling.
}
\examples{
\donttest{
# load germancredit data
data("germancredit")

# filter variable via missing rate, iv, identical value rate
dt_sel = var_filter(germancredit, "creditability")

# woe binning ------
bins = woebin(dt_sel, "creditability")
dt_woe = woebin_ply(dt_sel, bins)

# glm ------
m = glm(creditability ~ ., family = binomial(), data = dt_woe)

# Select a formula-based model by AIC
m_step = step(m, direction="both", trace=FALSE)
m = eval(m_step$call)

# scorecard
# Example I # creat a scorecard
card = scorecard(bins, m)
card2 = scorecard2(bins=bins, dt=germancredit, y='creditability',
  x= sub('_woe', '', names(coef(m))[-1]))

# credit score
# Example I # only total score
score1 = scorecard_ply(germancredit, card)

# Example II # credit score for both total and each variable
score2 = scorecard_ply(germancredit, card, only_total_score = FALSE)
}
}
\seealso{
\code{\link{scorecard}} \code{\link{scorecard_ply}}
}
