% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/post_hoc.R
\name{friedmanPost}
\alias{friedmanPost}
\title{Friedman's post hoc raw p-values}
\usage{
friedmanPost(data, control = NULL, ...)
}
\arguments{
\item{data}{Data set (matrix or data.frame) to apply the test. The column names are taken as the groups and the values in the matrix are the samples.}

\item{control}{Either the number or the name of the column for the control algorithm. If this parameter is not provided, the all vs all comparison is performed.}

\item{...}{Not used.}
}
\value{
A matrix with all the pairwise raw p-values (all vs. all or all vs. control).
}
\description{
This function computes the raw p-values for the post hoc based on Friedman's test.
}
\details{
The test has been implemented according to the version in Demsar (2006), page 12.
}
\examples{
data(data_gh_2008)
friedmanPost(data.gh.2008)
friedmanPost(data.gh.2008, control=1)
}
\references{
J. Demsar (2006) Statistical Comparisons of Classifiers over Multiple Data Sets. \emph{Journal of Machine Learning Research}, 7, 1-30.
}

