% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issue_extract.R
\name{issue_extract}
\alias{issue_extract}
\title{Export GitHub issues as PDF Files}
\usage{
issue_extract(
  repo_url = NULL,
  issue_nums = 1:10,
  export_folder = NULL,
  cookies = NULL,
  quiet = FALSE
)
}
\arguments{
\item{repo_url}{(character) URL of the GitHub repository as a character string.}

\item{issue_nums}{(numeric) Numeric vector of the issue numbers to be exported. Default is issue #1 through #10.}

\item{export_folder}{(character) Name of the folder that will be created to contain the output PDF files. Default is "exported_issues".}

\item{cookies}{(character) Optional file path to the cookies to load into the Chrome session. This is only required when accessing GitHub repositories that require a login. See this link for more details: https://github.com/rstudio/chromote/blob/main/README.md#websites-that-require-authentication.}

\item{quiet}{(logical) Whether to silence informative messages while issues are being exported. Default is FALSE.}
}
\value{
No return value, called for side effects
}
\description{
Exports specified GitHub issues as PDF files when given the URL of a GitHub repository and a numeric vector of GitHub issue numbers. This function will export the first 10 issues as a default.
}
\examples{
\dontrun{
# Export GitHub issue #7000 and #7080 through #7089 for the public `dplyr` repository 
issue_extract(repo_url = "https://github.com/tidyverse/dplyr",
              issue_nums = c(7000, 7080:7089),
              export_folder = "dplyr_issues")
}

}
