% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{close_enough}
\alias{close_enough}
\title{Check whether two numeric vectors are close enough for gov't work.}
\usage{
close_enough(x, y, tol = 10^-3)
}
\arguments{
\item{x}{a numeric vector}

\item{y}{another numeric vector}

\item{tol}{tolerance (default: \code{10^-3}.)}
}
\value{
\code{TRUE} if all numbers are near enough within the tolerance, otherwise \code{FALSE}
}
\description{
This is like \code{dplyr::near()} except with much less precision.
}
\examples{

close_enough(0.0004, 0)
close_enough(0.8887, 0.8884)
close_enough(1, 2)
}
\author{
Kelly Sovacool \email{sovacool@umich.edu}
}
