% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_cases.R
\name{smooth_cases}
\alias{smooth_cases}
\title{Smoothing single-case data}
\usage{
smooth_cases(data, dvar, mvar, method = "mean", intensity = NULL, FUN = NULL)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{method, FUN}{Method determining the smoothed scores. Default \code{method =
"median"} is a moving median function. Further possible values are:
\code{"mean"} and a non-parametric \code{"regression"}.}

\item{intensity}{For \code{method = "median"} and \code{"mean"} it
is the lag used for computing the average. Default is \code{intensity = 1}.
In case of \code{method = "regression"} it is the proportion of
surrounding data influencing each data point, which is \code{intensity =
0.2} by default.}
}
\value{
Returns a data frame (for each single-case) with smoothed data
points. See \code{\link{scdf}} to learn about the format of these data
frames.
}
\description{
*This function is superseded by the more versatile 
\code{\link{transform.scdf}} function.*
The \code{smooth_cases} function provides procedures to smooth single-case 
data (i.e., to eliminate noise). A moving average function (mean- or
median-based) replaces each data point by the average of the surrounding
data points step-by-step. With a local regression function, each data point
is regressed by its surrounding data points.
}
\details{
\code{moving_median}, \code{moving_mean}, and \code{local_regression} are 
helper function for \code{\link{transform.scdf}} returning the smoothed 
values of a numeric vector.
}
\examples{

## Use the three different smoothing functions and compare the results
study <- c(
  "Original" = Huber2014$Berta,
  "Moving median" = smooth_cases(Huber2014$Berta, method = "median"),
  "Moving mean" = smooth_cases(Huber2014$Berta, method = "mean"),
  "Local regression" = smooth_cases(Huber2014$Berta, method = "regression")
)
plot(study)

Huber2014$Berta \%>\% 
transform(
  "compliance (moving median)" = moving_median(compliance),
  "compliance (moving mean)" = moving_mean(compliance),
  "compliance (local regression)" = local_regression(compliance, mt)
)

}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as.data.frame.scdf}()},
\code{\link{as_scdf}()},
\code{\link{fill_missing}()},
\code{\link{moving_median}()},
\code{\link{outlier}()},
\code{\link{ranks}()},
\code{\link{scdf}},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{internal}
