% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_reviewNeurons.R
\name{updateNeuronsInteractive}
\alias{updateNeuronsInteractive}
\title{Update the classifications of specified neurons from SCALPEL.}
\usage{
updateNeuronsInteractive(scalpelOutput, neuronSet)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{The set of neurons that should be reviewed:
use \code{"A"} for those resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A}, or use \code{"Afilter"} for those resulting from
\code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}. This argument is ignored if the class of \code{scalpelOutput} is \code{scalpelStep2}.}
}
\value{
None
}
\description{
This function allows the user to update the classifications of neurons, which
were reviewed previously using \code{\link{reviewNeuronsInteractive}}. Typically, this function
is used after running \code{\link{reviewNeuronsMoreFrames}}.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "reviewNeuronsInteractive" function

updateNeuronsInteractive(scalpelOutput = scalpelOutput, neuronSet = "A")
#you will be prompted for the changes you wish to make
}
}
\seealso{
\code{\link{reviewNeuronsInteractive}}, \code{\link{reviewNeuronsMoreFrames}}, \code{\link{reviewOverlappingNeurons}}
}

