% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_scMappR_custom.R
\name{tissue_scMappR_custom}
\alias{tissue_scMappR_custom}
\title{Gene List Visualization and Enrichment with Custom Signature Matrix}
\usage{
tissue_scMappR_custom(
  gene_list,
  signature_matrix,
  output_directory = "custom_test",
  toSave = FALSE,
  path = NULL,
  gene_cutoff = 1,
  is_pvalue = TRUE
)
}
\arguments{
\item{gene_list}{A list of gene symbols matching that of the signature_matrix. Any gene symbol is acceptable.}

\item{signature_matrix}{Pre-computed signature matrix with matching gene names.}

\item{output_directory}{Directory made containing output of functions.}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}

\item{gene_cutoff}{Value cut-off (generally rank := log10(Padj)) for a gene to be considered a marker.}

\item{is_pvalue}{If signature matrix is p-value before rank is applied (not recommended) (T/F).}
}
\value{
List with the following elements:
\item{background_heatmap}{Data frame of the entire gene by cell-type signature matrix inputted.}
\item{gene_list_heatmap}{Data frame of inputted signature matrix subsetted by input genes.}
\item{single_celltype_preferences}{Data frame of enriched cell-types.}
\item{group_celtype_preference}{Data frame of groups of cell-types enriched by the same genes.}
}
\description{
This function visualizes signature matrix, clusters subsetted genes, completes enrichment of individual cell-types and co-enrichment.
}
\details{
This function is roughly the same as tissue_scMappR_internal, however now there is a custom signature matrix.
It generates a heatmap of the signature matrix and your inputted gene list, as well as single cell-type and 
co-celltype enrichment.
}
\examples{


# load in signature matrices
data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
sig <- get_gene_symbol(POA_Rank_signature)
Signature <- POA_Rank_signature
rownames(Signature) <- sig$rowname
genes <- rownames(Signature)[1:60]
heatmap_test <- tissue_scMappR_custom( genes, signature_matrix = Signature,
                                      output_directory =  "scMappR_test", toSave = FALSE)

}
