% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicPlot.R
\name{BasicPlot}
\alias{BasicPlot}
\title{Draw a variety of diagrams}
\usage{
BasicPlot(plot_fun, contigList, sampleName)
}
\arguments{
\item{plot_fun}{Drawing function.}

\item{contigList}{List which produced by TCR.ContigList() or BCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
Draw a variety of diagrams
}
\examples{
project_data_dir <- "F:/R_Language/data/tcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")

contig_list <- TCR.ContigList(project_data_dir, sample_name, group_name)
BasicPlot(TCR.ClonalStateDistribution, contig_list, sample_name)
}
