% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_jackstraw.R
\name{run_jackstraw}
\alias{run_jackstraw}
\title{Run jackstraw to get genes that are significantly associated with donor scores
for factors extracted by Tucker decomposition}
\usage{
run_jackstraw(
  container,
  ranks,
  n_fibers = 100,
  n_iter = 500,
  tucker_type = "regular",
  rotation_type = "hybrid",
  seed = container$experiment_params$rand_seed,
  ncores = container$experiment_params$ncores
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{ranks}{numeric The number of donor ranks and gene ranks to decompose to
using Tucker decomposition}

\item{n_fibers}{numeric The number of fibers the randomly shuffle in each iteration
(default=100)}

\item{n_iter}{numeric The number of shuffling iterations to complete (default=500)}

\item{tucker_type}{character Set to 'regular' to run regular tucker or to 'sparse' to run tucker
with sparsity constraints (default='regular')}

\item{rotation_type}{character Set to 'hybrid' to perform hybrid rotation on resulting donor factor
matrix and loadings. Otherwise set to 'ica_lds' to perform ica rotation on loadings or
ica_dsc to perform ica on donor scores. (default='hybrid')}

\item{seed}{numeric Seed passed to set.seed() (default=container$experiment_params$rand_seed)}

\item{ncores}{numeric The number of cores to use (default=container$experiment_params$ncores)}
}
\value{
The project container with a vector of adjusted pvalues in container$gene_score_associations.
}
\description{
Run jackstraw to get genes that are significantly associated with donor scores
for factors extracted by Tucker decomposition
}
\examples{
test_container <- run_jackstraw(test_container, ranks=c(2,4), n_fibers=2, n_iter=10,
tucker_type='regular', rotation_type='hybrid', ncores=1)
}
