% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Extract_Modality}
\alias{Extract_Modality}
\title{Extract multi-modal data into list by modality}
\usage{
Extract_Modality(matrix_list)
}
\arguments{
\item{matrix_list}{list of matrices to split by modality}
}
\value{
list of lists, with one sublist per data modality.  Sub-list contain 1 matrix entry per sample
}
\description{
Reorganize multi-modal data after import with \code{Read10X()} or scCustomize read functions.
Organizes sub-lists by data modality instead of by sample.
}
\examples{
\dontrun{
multi_mat <- Read10X(...)
new_multi_mat <- Extract_Modality(matrix_list = multi_mat)
}

}
\concept{read_merge_util}
