% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{Cluster_Highlight_Plot}
\alias{Cluster_Highlight_Plot}
\title{Cluster Highlight Plot}
\usage{
Cluster_Highlight_Plot(
  seurat_object,
  cluster_name,
  highlight_color = NULL,
  background_color = "lightgray",
  pt.size = NULL,
  aspect_ratio = NULL,
  figure_plot = FALSE,
  raster = NULL,
  raster.dpi = c(512, 512),
  label = FALSE,
  split.by = NULL,
  split_seurat = FALSE,
  ggplot_default_colors = FALSE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{cluster_name}{Name(s) (or number(s)) identity of cluster to be highlighted.}

\item{highlight_color}{Color(s) to highlight cells.  The default is NULL and plot will use
\code{scCustomize_Palette()}.}

\item{background_color}{non-highlighted cell colors.}

\item{pt.size}{point size for both highlighted cluster and background.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{figure_plot}{logical.  Whether to remove the axes and plot with legend on left of plot denoting
axes labels.  (Default is FALSE).  Requires \code{split_seurat = TRUE}.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{label}{Whether to label the highlighted cluster(s).  Default is FALSE.}

\item{split.by}{Feature to split plots by (i.e. "orig.ident").}

\item{split_seurat}{logical.  Whether or not to display split plots like Seurat (shared y axis) or as
individual plots in layout.  Default is FALSE.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Create Plot with cluster of interest highlighted
}
\examples{
Cluster_Highlight_Plot(seurat_object = pbmc_small, cluster_name = "1", highlight_color = "gold",
background_color = "lightgray",  pt.size = 2)

}
\concept{seurat_plotting}
