% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Plotting.R
\name{plotFactors_scCustom}
\alias{plotFactors_scCustom}
\title{Customized version of plotFactors}
\usage{
plotFactors_scCustom(
  liger_object,
  num_genes = 8,
  colors_use_factors = NULL,
  colors_use_dimreduc = c("lemonchiffon", "red"),
  pt.size_factors = 1,
  pt.size_dimreduc = 1,
  reduction_label = "UMAP",
  raster = TRUE,
  raster.dpi = c(512, 512),
  order = FALSE,
  plot_dimreduc = TRUE,
  save_plots = TRUE,
  file_path = NULL,
  file_name = NULL,
  return_plots = FALSE,
  cells.highlight = NULL,
  reorder_datasets = NULL,
  ggplot_default_colors = FALSE,
  color_seed = 123
)
}
\arguments{
\item{liger_object}{\code{liger} liger_object.  Need to perform clustering and factorization before calling this function}

\item{num_genes}{Number of genes to display for each factor (Default 8).}

\item{colors_use_factors}{colors to use for plotting factor loadings  By default datasets will be
plotted using "varibow" with shuffle = TRUE from both from \code{\link{DiscretePalette_scCustomize}}.}

\item{colors_use_dimreduc}{colors to use for plotting factor loadings on dimensionality reduction
coordinates (tSNE/UMAP).  Default is c('lemonchiffon', 'red'),}

\item{pt.size_factors}{Adjust point size for plotting in the factor plots.}

\item{pt.size_dimreduc}{Adjust point size for plotting in dimensionality reduction plots.}

\item{reduction_label}{What to label the x and y axes of resulting plots.  LIGER does not store name of
technique and therefore needs to be set manually.  Default is "UMAP".}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{order}{logical. Whether to plot higher loading cells on top of cells with lower loading values in the
dimensionality reduction plots (Default = FALSE).}

\item{plot_dimreduc}{logical.  Whether to plot factor loadings on dimensionality reduction coordinates.  Default is TRUE.}

\item{save_plots}{logical.  Whether to save plots.  Default is TRUE}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix to append after sample name.}

\item{return_plots}{logical. Whether or not to return plots to the environment.  (Default is FALSE)}

\item{cells.highlight}{Names of specific cells to highlight in plot (black) (default NULL).}

\item{reorder_datasets}{New order to plot datasets in for the factor plots if different from current
factor level order in cell.data slot.}

\item{ggplot_default_colors}{logical.  If \code{colors_use_factors = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "varibow" palette.}

\item{color_seed}{random seed for the palette shuffle if \code{colors_use_factors = NULL}.  Default = 123.}
}
\value{
A list of ggplot/patchwork objects and/or PDF file.
}
\description{
Modified and optimized version of \code{plotFactors} function from LIGER package.
}
\examples{
\dontrun{
plotFactors_scCustom(liger_object = liger_obj, return_plots = FALSE, plot_dimreduc = TRUE,
raster = FALSE, save_plots = TRUE)
}

}
\references{
Based on \code{plotFactors} functionality from original LIGER package.
}
\author{
Velina Kozareva (Original code for modified function), Sam Marsh (Added/modified functionality)
}
\concept{liger_plotting}
