% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_sbo_predictor.R
\name{predict.sbo_predictor}
\alias{predict.sbo_predictor}
\title{Predict method for Stupid Back-off text predictor}
\usage{
\method{predict}{sbo_predictor}(object, input, ...)
}
\arguments{
\item{object}{a \code{sbo_predictor} object.}

\item{input}{a character vector, containing the input for next-word prediction.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A character vector if \code{length(input) == 1}, otherwise a
character matrix.
}
\description{
Predictive text based on Stupid Back-off N-gram model.
}
\details{
This method returns the top \code{L} next-word predictions from a
text predictor trained with Stupid Back-Off.

Trying to predict from a \code{sbo_predtable} results into an error. Instead,
one should load a \code{sbo_predictor} object and use this one to predict(),
as shown in the example below.
}
\examples{
p <- sbo_predictor(twitter_predtable)
x <- predict(p, "i love")
x
x <- predict(p, "you love")
x
#N.B. the top predictions here are x[1], followed by x[2] and x[3].
predict(p, c("i love", "you love")) # Behaviour with length()>1 input.
}
\author{
Valerio Gherardi
}
