% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-BipartiteSBM_sampler.R
\name{BipartiteSBM_sampler}
\alias{BipartiteSBM_sampler}
\title{R6 class for Bipartite SBM sampler}
\description{
R6 class for Bipartite SBM sampler

R6 class for Bipartite SBM sampler
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:SBM_sampler]{sbm::SBM_sampler}} -> \code{BipartiteSBM_sampler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nbNodes}}{vector of size 2: number of nodes (rows, columns)}

\item{\code{nbBlocks}}{vector of size 2: number of blocks (rows, columns)}

\item{\code{nbDyads}}{number of dyads (potential edges in the network)}

\item{\code{nbConnectParam}}{number of parameter used for the connectivity}

\item{\code{memberships}}{list of size 2: vector of memberships in row, in column.}

\item{\code{indMemberships}}{list of 2 matrix for clustering memberships}

\item{\code{expectation}}{expected values of connection under the current model}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BipartiteSBM_sampler$new()}}
\item \href{#method-rMemberships}{\code{BipartiteSBM_sampler$rMemberships()}}
\item \href{#method-rIncidence}{\code{BipartiteSBM_sampler$rIncidence()}}
\item \href{#method-show}{\code{BipartiteSBM_sampler$show()}}
\item \href{#method-clone}{\code{BipartiteSBM_sampler$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="plot">}\href{../../sbm/html/SBM.html#method-plot}{\code{sbm::SBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_sampler$new(
  model,
  nbNodes,
  blockProp,
  connectParam,
  dimLabels = list(row = "rowLabel", col = "colLabel"),
  covarParam = numeric(0),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character describing the type of model}

\item{\code{nbNodes}}{number of nodes in the network}

\item{\code{blockProp}}{parameters for block proportions (vector of list of vectors)}

\item{\code{connectParam}}{list of parameters for connectivity with a matrix of means 'mean' and an optional scalar for the variance 'var'. The dimensions of mu must match \code{blockProp} lengths}

\item{\code{dimLabels}}{optional labels of each dimension (in row, in column)}

\item{\code{covarParam}}{optional vector of covariates effect}

\item{\code{covarList}}{optional list of covariates data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rMemberships"></a>}}
\if{latex}{\out{\hypertarget{method-rMemberships}{}}}
\subsection{Method \code{rMemberships()}}{
a method to generate a vector of block indicators
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_sampler$rMemberships()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rIncidence"></a>}}
\if{latex}{\out{\hypertarget{method-rIncidence}{}}}
\subsection{Method \code{rIncidence()}}{
a method to sample an adjacency matrix for the current SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_sampler$rIncidence()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing (sampled matrix is store in the current object, accessible via $netMatrix)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_sampler$show(
  type = "Sampler for a Bipartite Stochastic Block Model"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_sampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
