% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDODN.R
\docType{methods}
\name{calcDODN}
\alias{calcDODN}
\alias{calcDODN,Satellite-method}
\alias{calcDODN,RasterLayer-method}
\title{Compile dark object DN for given sensor band}
\usage{
\S4method{calcDODN}{Satellite}(x, bcde)

\S4method{calcDODN}{RasterLayer}(x)
}
\arguments{
\item{x}{Satellite object or RasterLayer with sensor band data, e.g. returned 
by \code{\link{getSatDataLayer}}.}

\item{bcde}{If 'x' is a Satellite object, a band code as character.}
}
\value{
Numeric value of the DN for the dark object.
}
\description{
The function estimates the DN value of a "dark object" which is used for 
atmospheric correction using the DOS2 and DOS4 model. Therefore, the 
frequency distribution of the smallest 1\% of the data values is analyzed 
and the value for which the first derivate has the absolute maximum is
taken as the DN for a dark object.
}
\details{
The DN for a dark object is extracted from a histogram similar to
Chavez (1988).
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

calcDODN(sat, bcde = "B002n")
calcDODN(getSatDataLayer(sat, bcde = "B002n"))

}
\references{
Chavez Jr PS (1988) An improved dark-object subtraction technique 
for atmospheric scattering correction of multispectral data. Remote Sensing 
of Environment 24/3, doi:10.1016/0034-4257(88)90019-3, available online at
 \url{http://www.sciencedirect.com/science/article/pii/0034425788900193}
}
\seealso{
The DN is used by \code{\link{calcPathRadDOS}} for computing the 
path radiance based on the dark object method.
}
