% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/projectSatellite.R
\docType{methods}
\name{projectSatellite}
\alias{projectSatellite}
\alias{projectSatellite,Satellite-method}
\title{Reproject a 'Satellite' object}
\usage{
\S4method{projectSatellite}{Satellite}(x, template, band_codes, type, crs,
  method = c("bilinear", "ngb"))
}
\arguments{
\item{x}{Satellite or Raster* object to be resampled.}

\item{template}{Raster* or spatial data set from which geometry can be
extracted.}

\item{band_codes}{Band ID(s) to be resampled. If not supplied and type is
not given, too, all bands will be considered for resampling.}

\item{type}{Type of bands (e.g. VIS, NIR) which should be considered. If not
supplied, all types will be processed depending and bands to be processed can
be defined by band_codes.}

\item{crs}{character or object of class 'CRS'.
PROJ.4 description of the coordinate reference system.
See \code{\link{projectRaster}} for details.}

\item{method}{Method for resampling; "bilinear" for bilinear interpolation
(default) or "ngb" for nearest neighbor interpolation. See e.g.
\code{\link{resample}}, \code{\link{projectRaster}}.}
}
\description{
Reproject a satellite object. Either a \code{template} or \code{crs}
must be supplied. If \code{crs} is not supplied, \code{\link{alignGeometry}}
is called.
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC8*.tif"), full.names = TRUE)
sat <- satellite(files)

projectSatellite(sat, crs = "+init=epsg:4326", band_codes = "B001n")
}

