% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{tic}
\alias{tic}
\title{Tail importance coefficients for Mevlog models.}
\usage{
tic(ds, ind = 2, n.MC = 1000, sobol = FALSE)
}
\arguments{
\item{ds}{An object of class \code{ds}.}

\item{ind}{A character string among "with.singletons" and "all" (without singletons), or an integer in \eqn{\{2,...,d\}} or a list of subsets from  \eqn{\{1,...,d\}}. The default is \code{ind = 2}, all pairwise coefficients are computed.}

\item{n.MC}{Monte Carlo sample size. Default value is 1000. See details in  \code{\link[satdad]{tsic}}.}

\item{sobol}{A boolean. `FALSE` (the default). If `TRUE`:  the index is normalized by the theoretical global variance.}
}
\value{
The function returns a list of two elements:
\itemize{
\item{\code{subsets}} A list of subsets from  \eqn{\{1,...,d\}}.

When \code{ind} is given as an integer, \code{subsets} is the list of subsets from  \eqn{\{1,...,d\}} with cardinality \code{ind}.

When \code{ind} is a list, it corresponds to \code{subsets}.

When \code{ind = "with.singletons"}  subsets is the list of all non empty subsets in \eqn{\{1,...,d\}}.

When \code{ind = "all"}   subsets is the list of all subsets in \eqn{\{1,...,d\}} with cardinality larger or equal to 2.

\item{\code{tic}} A vector of tail importance coefficients, or their Sobol versions when \code{sobol = "TRUE"}.
}
}
\description{
Computes  the tail  importance coefficients (tic) on a \code{Mevlog} model which is a multivariate extreme value (symmetric or asymmetric) logistic model, descibed here by its dependence structure.
}
\details{
The tail dependence structure is specified using a \code{ds} object, which corresponds to the stable tail dependence function  \eqn{\ell}.
The process for deducing  the stable tail dependence function \eqn{\ell} from \code{ds} is explained in the Details section of \code{\link[satdad]{gen.ds}}.

The theoretical functional decomposition of the variance of the stdf \eqn{\ell} consists in writing \eqn{D(\ell) = \sum_{I \subseteq \{1,...,d\}} D_I(\ell) } where \eqn{D_I(\ell)} measures the variance of \eqn{\ell_I(U_I)} the term associated with subset \eqn{I} in the Hoeffding-Sobol decomposition of \eqn{\ell}
; note that \eqn{U_I} represents  a random vector with independent standard uniform entries.
The theoretical tail importance coefficient (tic) is thus \eqn{D_I(\ell)} and  its sobol version is \eqn{S_I(\ell)=\dfrac{D_I(\ell)}{D(\ell)}}.

The function \code{tic} uses the Mobius inversion formula, see Formula (8) in Liu and Owen (2006), to derive the tic from the tsic. The latter are the tail superset importance coefficients obtained by the function \code{\link[satdad]{tsic}}.
}
\examples{

## Fix a 4-dimensional asymmetric tail dependence structure
ds4 <- gen.ds(d = 4, sub = list(1:2,3:4,1:3))

## Compute all tic values
res4 <- tic(ds4, ind = "with.singletons", sobol = TRUE)

## Check the sum-to-one constraint of tail Sobol indices
sum(res4$tic)

}
\references{
Liu, R. and Owen, A. B. (2006)
Estimating mean dimensionality of analysis of variance decompositions.
\emph{J. Amer. Statist. Assoc.}, \bold{101(474)}:712--721.

Mercadier, C. and Roustant, O. (2019)
The tail dependograph.
\emph{Extremes}, \bold{22}, 343--372.
}
\seealso{
\code{\link[satdad]{tsic}}, \code{\link[satdad]{ticEmp}}

\code{\link[satdad]{ticEmp}} and \code{\link[satdad]{tsic}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
