% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofile.R
\name{new_snowprofile}
\alias{new_snowprofile}
\title{Low-level constructor function for a snowprofile object}
\usage{
new_snowprofile(
  station = character(),
  station_id = character(),
  datetime = as.POSIXct(NA),
  latlon = as.double(c(NA, NA)),
  elev = double(),
  angle = double(),
  aspect = double(),
  hs = double(),
  maxObservedDepth = double(),
  type = character(),
  band = character(),
  zone = character(),
  comment = character(),
  hn24 = double(),
  hn72 = double(),
  ski_pen = double(),
  layers = snowprofileLayers(),
  tests = snowprofileTests(),
  instabilitySigns = snowprofileInstabilitySigns()
)
}
\arguments{
\item{station}{character string}

\item{station_id}{character string}

\item{datetime}{date and time as class POSIXct in most meaningful timezone (timezone can be converted very easily:
e.g. \code{print(profile$datetime, tz = 'EST')}.}

\item{latlon}{2-element vector latitude (first), longitude (second)}

\item{elev}{profile elevation (m)}

\item{angle}{slope angle (degree)}

\item{aspect}{slope aspect (degree)}

\item{hs}{total snow height (cm); if not provided, the field will be derived from the profile layers.}

\item{maxObservedDepth}{equivalent to \code{hs} for full profiles that go down to the ground. for test profiles that only
observe the upper part of the snowpack this value refers to the maximum depth of the profile observation.}

\item{type}{character string, must be either 'manual', 'modeled', 'vstation', 'aggregate', or 'whiteboard'}

\item{band}{character string describing elevation band as ALP, TL, BTL (alpine, treeline, below treeline)}

\item{zone}{character string describing the zone or region of the profile location (e.g., BURNABY_MTN)}

\item{comment}{character string with any text comments}

\item{hn24}{height of new snow within 24 h}

\item{hn72}{height of new snow within 72 h}

\item{ski_pen}{skier penetration depth (cm)}

\item{layers}{\link{snowprofileLayers} object}

\item{tests}{\link{snowprofileTests} object}

\item{instabilitySigns}{\link{snowprofileInstabilitySigns} object}
}
\value{
snowprofile object
}
\description{
Low-cost, efficient constructor function to be used by users who know what they're doing. If that's not you,
use the high-level constructor \link{snowprofile}.
}
