% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\alias{daily_metrics}
\alias{monthly_metrics}
\alias{nightly_metrics}
\alias{daylight_metrics}
\alias{predawn_metrics}
\alias{midday_metrics}
\title{Complete metrics wrappers}
\usage{
daily_metrics(sfn_data, solar = TRUE, probs = c(0.95), tidy = FALSE,
  metadata = NULL, ...)

monthly_metrics(sfn_data, solar = TRUE, probs = c(0.95),
  tidy = FALSE, metadata = NULL, ...)

nightly_metrics(sfn_data, period = c("1 day", "1 month"), solar = TRUE,
  int_start = 20, int_end = 6, probs = c(0.95), tidy = FALSE,
  metadata = NULL, ...)

daylight_metrics(sfn_data, period = c("1 day", "1 month"),
  solar = TRUE, int_start = 6, int_end = 20, probs = c(0.95),
  tidy = FALSE, metadata = NULL, ...)

predawn_metrics(sfn_data, period = c("1 day", "1 month"), solar = TRUE,
  int_start = 4, int_end = 6, probs = c(0.95), tidy = FALSE,
  metadata = NULL, ...)

midday_metrics(sfn_data, period = c("1 day", "1 month"), solar = TRUE,
  int_start = 11, int_end = 13, probs = c(0.95), tidy = FALSE,
  metadata = NULL, ...)
}
\arguments{
\item{sfn_data}{\code{\link{sfn_data}} or \code{\link{sfn_data_multi}} object
to obtain the metrics from}

\item{solar}{Logical indicating if the solarTIMESTAMP must be used instead of
the site local TIMESTAMP. Default to TRUE (use solarTIMESTAMP).}

\item{probs}{numeric vector of probabilities for
\code{\link[stats]{quantile}}}

\item{tidy}{Logical indicating if the metrics must be returned in a tidy
format (a long tibble, each observation in its own row)}

\item{metadata}{metadata object, usually the result of
\code{\link{read_sfn_metadata}}. Only used if tidy is TRUE.}

\item{...}{additional arguments to be passed to \code{\link{.collapse_timestamp}}
or \code{\link[lubridate]{floor_date}} or \code{\link[lubridate]{ceiling_date}}.}

\item{period}{Time period to aggregate data by. See period section for an
explanation about the periods ('1 day', '1 month', '1 year', ...)}

\item{int_start}{Integer value indicating the starting hour of the special
interval in 24h format. See Interval section in details.}

\item{int_end}{Integer value indicating the ending hour of the special
interval in 24h format. See Interval section in details.}
}
\value{
If \code{tidy} is TRUE, a tibble with the metrics for
  sapflow and environmental data, with all the metadata included. If
  \code{tidy} is FALSE (default), a list of tibbles with the calculated
  metrics.
}
\description{
This set of functions returns a complete set of statistics for a site (using
\code{\link{sfn_data}}) or several sites (using \code{\link{sfn_data_multi}})
}
\details{
\code{*_metrics} functions are wrappers for \code{\link{sfn_metrics}} with a
set of fixed arguments.

\code{*_metrics} functions return all or some of the following statistics:
\itemize{
  \item{mean: mean of variable (tree or environmental variable) for the
        given period. NAs are removed}
  \item{sd: standard deviation of the variable for the givn period. NAs are
        removed}
  \item{coverage: Data coverage percentage (percentage of measures without
        NAs)}
  \item{q_XX: 0.XX quantile value for the period}
  \item{centroid: Diurnal centroid value (hours passed until the half of
        the summed daily value was reached). Only returned for sapflow
        measures when period is '1 day'}
  \item{accumulated: Accumulated values for precipitation only}
}
}
\section{daily_metrics}{

\code{daily_metrics} summarise daily data for all hours in the day
}

\section{monthly_metrics}{

\code{monthly_metrics} summarise monthly data for all hours in the day.
}

\section{nightly_metrics}{

\code{nightly_metrics} will return the metrics for night
periods, summarised daily or monthly

Night for daily period starts in DOY x and ends in DOY x+1 (i.e. if
\code{night_start = 20, night_end = 6} values for the night starting at
2018-03-28 20:00:00 and ending at 2018-03-29 06:00:00 are summarised).

Night for monthly period summarises all night periods in the month, that
includes from 00:00:00 of the first month night to 23:59:59 of the last
month night.
}

\section{daylight_metrics}{

\code{daylight_metrics} will return the metrics for daylight
periods, summarised daily or monthly. Daylight interval is selected by start
and end hours.
}

\section{predawn_metrics}{

\code{predawn_metrics} will always return the metrics for predawn
period, summarised daily or monthly. Predawn interval is selected by start and
end hours.

Predawn metrics did not return the centroid metric.
}

\section{midday_metrics}{

\code{midday_metrics} will always return the metrics for midday
period, summarised daily or monthly. midday interval is selected by start and
end hours.

Midday metrics did not return the centroid metric.
}

\examples{
## daily_metrics
# data load
data('ARG_TRE', package = 'sapfluxnetr')
data('sfn_metadata_ex', package = 'sapfluxnetr')

# non tidy raw metrics (default)
ARG_TRE_raw_daily <- daily_metrics(ARG_TRE)
str(ARG_TRE_raw_daily)

\donttest{
# tidy daily metrics
ARG_TRE_daily <- daily_metrics(
  ARG_TRE, tidy = TRUE, metadata = sfn_metadata_ex
)
ARG_TRE_daily
}

## monthly_metrics
# data load
data('ARG_TRE', package = 'sapfluxnetr')
data('sfn_metadata_ex', package = 'sapfluxnetr')

# non tidy raw metrics (default)
ARG_TRE_raw_monthly <- monthly_metrics(ARG_TRE)
str(ARG_TRE_raw_monthly)

\donttest{
# tidy monthly metrics
ARG_TRE_monthly <- monthly_metrics(
  ARG_TRE, tidy = TRUE, metadata = sfn_metadata_ex
)
ARG_TRE_monthly
}

\donttest{
## nightly_metrics
# data load
data('AUS_CAN_ST2_MIX', package = 'sapfluxnetr')

# non tidy daily night metrics (default)
AUS_CAN_ST2_MIX_night <- nightly_metrics(AUS_CAN_ST2_MIX)

str(AUS_CAN_ST2_MIX_night)
AUS_CAN_ST2_MIX_night[['sapf']]
AUS_CAN_ST2_MIX_night[['env']]

# change the night interval
AUS_CAN_ST2_MIX_night_short <- nightly_metrics(
  AUS_CAN_ST2_MIX, int_start = 21, int_end = 4 # night starting and ending hour
)
AUS_CAN_ST2_MIX_night_short[['env']]

# tidy nightly metrics
data('sfn_metadata_ex', package = 'sapfluxnetr')
AUS_CAN_ST2_MIX_night_tidy <- nightly_metrics(
  AUS_CAN_ST2_MIX,
  tidy = TRUE, metadata = sfn_metadata_ex
)
AUS_CAN_ST2_MIX_night_tidy
}

\donttest{
## daylight_metrics
# data load
data('AUS_CAN_ST2_MIX', package = 'sapfluxnetr')

# non tidy daily daylight metrics (default)
AUS_CAN_ST2_MIX_daylight <- daylight_metrics(AUS_CAN_ST2_MIX)

str(AUS_CAN_ST2_MIX_daylight)
AUS_CAN_ST2_MIX_daylight[['sapf']]
AUS_CAN_ST2_MIX_daylight[['env']]

# change the daylight interval
AUS_CAN_ST2_MIX_daylight_short <- daylight_metrics(
  AUS_CAN_ST2_MIX, int_start = 8, int_end = 18 # night starting and ending hour
)
AUS_CAN_ST2_MIX_daylight_short[['env']]

# tidy daylight metrics
data('sfn_metadata_ex', package = 'sapfluxnetr')
AUS_CAN_ST2_MIX_daylight_tidy <- daylight_metrics(
  AUS_CAN_ST2_MIX,
  tidy = TRUE, metadata = sfn_metadata_ex
)
AUS_CAN_ST2_MIX_daylight_tidy
}

\donttest{
## predawn_metrics
# data load
data('AUS_CAN_ST2_MIX', package = 'sapfluxnetr')

# non tidy daily predawn metrics (default)
AUS_CAN_ST2_MIX_predawn <- predawn_metrics(AUS_CAN_ST2_MIX)

str(AUS_CAN_ST2_MIX_predawn)
AUS_CAN_ST2_MIX_predawn[['sapf']]
AUS_CAN_ST2_MIX_predawn[['env']]

# change the predawn interval
AUS_CAN_ST2_MIX_predawn_short <- predawn_metrics(
  AUS_CAN_ST2_MIX, int_start = 8, int_end = 18 # night starting and ending hour
)
AUS_CAN_ST2_MIX_predawn_short[['env']]

# tidy daylight metrics
data('sfn_metadata_ex', package = 'sapfluxnetr')
AUS_CAN_ST2_MIX_predawn_tidy <- predawn_metrics(
  AUS_CAN_ST2_MIX,
  tidy = TRUE, metadata = sfn_metadata_ex
)
AUS_CAN_ST2_MIX_predawn_tidy
}

\donttest{
## midday_metrics
# data load
data('AUS_CAN_ST2_MIX', package = 'sapfluxnetr')

# non tidy daily midday metrics (default)
AUS_CAN_ST2_MIX_midday <- midday_metrics(AUS_CAN_ST2_MIX)

str(AUS_CAN_ST2_MIX_midday)
AUS_CAN_ST2_MIX_midday[['sapf']]
AUS_CAN_ST2_MIX_midday[['env']]

# change the midday interval
AUS_CAN_ST2_MIX_midday_short <- midday_metrics(
  AUS_CAN_ST2_MIX, int_start = 8, int_end = 18 # night starting and ending hour
)
AUS_CAN_ST2_MIX_midday_short[['env']]

# tidy daylight metrics
data('sfn_metadata_ex', package = 'sapfluxnetr')
AUS_CAN_ST2_MIX_midday_tidy <- midday_metrics(
  AUS_CAN_ST2_MIX,
  tidy = TRUE, metadata = sfn_metadata_ex
)
AUS_CAN_ST2_MIX_midday_tidy
}

}
\seealso{
Other metrics: \code{\link{sfn_metrics}}
}
\concept{metrics}
