% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_start_GUI.R
\name{santaR_start_GUI}
\alias{santaR_start_GUI}
\title{santaR Graphical User Interface}
\usage{
santaR_start_GUI(browser = TRUE)
}
\arguments{
\item{browser}{If TRUE open the graphical user interface in a web browser instead of a R window. Default is TRUE}
}
\value{
None, start GUI. To exit press \code{ESC} in the command line.
}
\description{
santaR Graphical User Interface (GUI) implements all the functions for short asynchronous time-series analysis. To exit press \code{ESC} in the command line. Once started, the GUI presents 4 tabs corresponding to the main steps of analysis: \emph{Import}, \emph{DF search}, \emph{Analysis} and \emph{Export}.
\itemize{
  \item The \emph{Import} tab manages input data in comma separated value (\emph{csv}) format or as an \emph{RData} file containing a \code{SANTAObj} previously generated with \pkg{santaR}. Once data is imported the \emph{DF search} and \emph{Analysis} tabs become available.
  \item \emph{DF search} implements the tools for the selection of an optimal number of degrees of freedom (\code{df}).
  \item With the data imported and a pertinent \code{df} selected, \emph{Analysis} regroups the interface to visualise and identify variables significantly altered over time. All options present in the command line version of \pkg{santaR} are available, with the added possibility to modify the class labelling of each subject (\emph{group}). A plotting interface enables the interactive visualisation of the raw data points, individual trajectories, group mean curves and confidence bands for all variables, which subsequently can be saved. Finally, if inter-group differential trajectories have been characterised, all significance testing results (with correction for multiple testing) are presented in interactive tables.
  \item The \emph{Export} tab manages the saving of results and automated reporting. Fitted data is saved as a \code{SANTAObj}, which contains all inputs and outputs, and can be downloaded as an \emph{RData} file for future analysis, or reproduction of results. \emph{csv} files containing significance testing results can also be generated and summary plot for each significantly altered variable saved for rapid evaluation.
}
\pkg{santaR}'s command line procedure is the most efficient approach for very high number of variables due to the added level of automation. However the GUI can help understand the use of the methodology, select the best parameters on a subset of the data, or to visually explore the results.
}
\examples{
\donttest{
## Start graphical interface, press 'ESC' in the command line to stop.
santaR_start_GUI()
}

}
\seealso{
Other AutoProcess: \code{\link{santaR_auto_fit}},
  \code{\link{santaR_auto_summary}},
  \code{\link{santaR_plot}}

Other Analysis: \code{\link{get_grouping}},
  \code{\link{get_ind_time_matrix}},
  \code{\link{santaR_CBand}},
  \code{\link{santaR_auto_fit}},
  \code{\link{santaR_auto_summary}},
  \code{\link{santaR_fit}}, \code{\link{santaR_plot}},
  \code{\link{santaR_pvalue_dist}},
  \code{\link{santaR_pvalue_fit}}
}
