% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_list_report_fields}
\alias{sf_list_report_fields}
\title{Get a list of report fields}
\usage{
sf_list_report_fields(
  report_id,
  intersect_with = c(character(0)),
  verbose = FALSE
)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{intersect_with}{\code{character} a vector of unique report IDs. This is
helpful in determining the best fields for use in dashboard filters by seeing
which fields different source reports have in common. If this argument is left
empty, then the function returns a list of all possible report fields.
Otherwise, returns a list of fields that specified reports share.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list} representing the 4 different field report properties:
\describe{
\item{displayGroups}{Fields available when adding a filter.}
\item{equivalentFields}{Fields available for each specified report. Each object in this array is a list of common fields categorized by report type.}
\item{equivalentFieldIndices}{Map of each field’s API name to the index of the field in the \code{equivalentFields} array.}
\item{mergedGroups}{Merged fields.}
}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

The Report Fields resource returns report fields available for specified reports.
Use the resource to determine the best fields for use in dashboard filters by
seeing which fields different source reports have in common. Available in API
version 40.0 and later.
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_get_fields.htm}{Documentation}
}
}

\examples{
\dontrun{
# first, grab all possible reports in your Org
all_reports <- sf_query("SELECT Id, Name FROM Report")

# second, get the id of the report to check fields on
this_report_id <- all_reports$Id[1]

# third, pull that report and intersect its fields with up to three other reports
fields <- sf_list_report_fields(this_report_id, intersect_with=head(all_reports[["Id"]],3))
}
}
\seealso{
Other Report functions: 
\code{\link{sf_copy_report}()},
\code{\link{sf_create_report}()},
\code{\link{sf_delete_report}()},
\code{\link{sf_describe_report_type}()},
\code{\link{sf_describe_report}()},
\code{\link{sf_execute_report}()},
\code{\link{sf_list_report_filter_operators}()},
\code{\link{sf_list_report_types}()},
\code{\link{sf_list_reports}()},
\code{\link{sf_query_report}()},
\code{\link{sf_run_report}()},
\code{\link{sf_update_report}()}
}
\concept{Report functions}
