% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_reset_password}
\alias{sf_reset_password}
\title{Reset User Password}
\usage{
sf_reset_password(user_id, control = list(...), ..., verbose = FALSE)
}
\arguments{
\item{user_id}{character; the unique Salesforce Id assigned to the User}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{list}
}
\description{
Changes a user’s password to a temporary, system-generated value.
}
\examples{
\dontrun{
# reset a user's password and ensure that an email is triggered to them
sf_reset_password(user_id = "0056A000000ZZZaaBBB", 
                  EmailHeader = list(triggerAutoResponseEmail = FALSE, 
                                     triggerOtherEmail = FALSE, 
                                     triggerUserEmail = TRUE))
}
}
