% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{design_sail}
\alias{design_sail}
\title{Sail design matrix}
\usage{
design_sail(x, e, expand, group, basis, nvars, vnames, center.x, center.e)
}
\arguments{
\item{x}{input matrix of dimension \code{n x p}, where \code{n} is the number
of subjects and p is number of X variables. Each row is an observation
vector. Can be a high-dimensional (n < p) matrix. Can be a user defined
design matrix of main effects only (without intercept) if
\code{expand=FALSE}}

\item{e}{exposure or environment vector. Must be a numeric vector. Factors
must be converted to numeric.}

\item{expand}{should \code{basis} be applied to every column of \code{x}
(logical). Set to \code{FALSE} if you want a user defined main effects
design matrix. If \code{FALSE} the \code{group} membership argument must
also be supplied. Default: \code{TRUE}.}

\item{group}{a vector of consecutive integers, starting from 1, describing
the grouping of the coefficients. Only required when \code{expand=FALSE}.}

\item{basis}{user defined basis expansion function. This function will be
applied to every column in \code{x}. Specify \code{function(i) i} if no
expansion is desired. Default: \code{function(i) splines::bs(i, df = 5)}.}

\item{nvars}{number of variables}

\item{vnames}{variable names}

\item{center.x}{should the columns of \code{x} (after basis expansion) be
centered (logical). Default: \code{TRUE}.}

\item{center.e}{should exposure variable \code{e} be centered. Default:
\code{TRUE}.}
}
\description{
Create design matrix used in \code{\link{sail}} function
}
