% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMapping.R
\name{makeMapping}
\alias{makeMapping}
\title{Create data mapping based on data standards and user input}
\usage{
makeMapping(domainData, meta, autoMapping, customMapping)
}
\arguments{
\item{domainData}{named list of data.frames to be loaded in to the app. Sample AdAM data from the safetyData package used by default}

\item{meta}{data frame containing the metadata for use in the app.}

\item{autoMapping}{boolean indicating whether the app should use \code{safetyGraphics::detectStandard()} to detect data standards and automatically generate mappings for the data provided. Values specified in the \code{customMapping} parameter overwrite auto-generated mappings when both are found. Defaults to true.}

\item{customMapping}{optional list specifying initial mapping values within each data mapping (e.g. list(aes= list(id_col='USUBJID', seq_col='AESEQ')).}
}
\value{
List containing data standard information and mapping
\itemize{
\item{"mapping"}{ Initial Data Mapping }
\item{"standards"}{ List of domain level data standards (or NULL if autoMapping is false) }
}
}
\description{
Create data mapping based on data standards and user input
}
